/*
 * Decompiled with CFR 0.152.
 */
package org.soulwing.cas.extension;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.staxmapper.XMLExtendedStreamWriter;
import org.soulwing.cas.extension.Names;
import org.soulwing.cas.extension.ResourceParser;
import org.soulwing.cas.extension.ResourceReader;
import org.soulwing.cas.extension.ResourceWriter;

public abstract class AbstractResourceReaderWriter
implements ResourceReader,
ResourceWriter {
    private final List<AbstractResourceReaderWriter> children = new ArrayList<AbstractResourceReaderWriter>();
    protected ResourceParser parser;
    private final String namespaceUri;
    private final String localName;

    public AbstractResourceReaderWriter(String localName) {
        this(Names.NAMESPACE, localName);
    }

    @SafeVarargs
    public AbstractResourceReaderWriter(String localName, AbstractResourceReaderWriter ... children) {
        this(Names.NAMESPACE, localName, children);
    }

    public AbstractResourceReaderWriter(String namespaceUri, String localName) {
        this.namespaceUri = namespaceUri;
        this.localName = localName;
    }

    @SafeVarargs
    public AbstractResourceReaderWriter(String namespaceUri, String localName, AbstractResourceReaderWriter ... children) {
        this.namespaceUri = namespaceUri;
        this.localName = localName;
        this.children.addAll(Arrays.asList(children));
    }

    @Override
    public void init(ResourceParser parser) {
        this.parser = parser;
    }

    @Override
    public boolean supports(String namespaceUri, String localName) {
        return this.namespaceUri.equals(namespaceUri) && this.localName.equals(localName);
    }

    @Override
    public void startElement(XMLStreamReader reader, String namespaceUri, String localName) throws XMLStreamException {
        for (AbstractResourceReaderWriter child : this.children) {
            if (!child.supports(namespaceUri, localName)) continue;
            this.parser.push(child);
            child.handleAttributes(reader);
            return;
        }
        this.parser.unexpectedElement(reader);
    }

    @Override
    public void endElement(XMLStreamReader reader, String namespaceUri, String localName) throws XMLStreamException {
        if (!this.supports(namespaceUri, localName)) {
            this.parser.unexpectedEndElement(reader);
        }
        this.parser.pop();
    }

    @Override
    public void characters(XMLStreamReader reader, String text) throws XMLStreamException {
        if (!text.trim().isEmpty()) {
            throw new XMLStreamException("unexpected text: " + text, reader.getLocation());
        }
    }

    protected void handleAttributes(XMLStreamReader reader) throws XMLStreamException {
        String key = this.getResourceKey();
        SimpleAttributeDefinition[] attributes = this.attributes();
        HashSet<String> names = new HashSet<String>();
        String resourceName = null;
        ModelNode op = new ModelNode();
        op.get("operation").set("add");
        int max = reader.getAttributeCount();
        block0: for (int i = 0; i < max; ++i) {
            String localName = reader.getAttributeLocalName(i);
            String value = reader.getAttributeValue(i);
            if (key.equals(localName)) {
                resourceName = value;
                continue;
            }
            for (SimpleAttributeDefinition attribute : attributes) {
                if (!attribute.getXmlName().equals(localName)) continue;
                names.add(localName);
                attribute.parseAndSetParameter(value, op, reader);
                continue block0;
            }
            this.parser.unexpectedAttribute(reader, i);
        }
        HashSet<String> missing = new HashSet<String>();
        if (resourceName == null) {
            missing.add(key);
        }
        for (SimpleAttributeDefinition attribute : attributes) {
            if (names.contains(attribute.getXmlName()) || !attribute.isRequired(op)) continue;
            missing.add(attribute.getXmlName());
        }
        if (!missing.isEmpty()) {
            this.parser.missingAttributes(reader, missing);
        }
        this.parser.addOperation(op, this.getResourceType(), resourceName);
    }

    @Override
    public void writeResource(XMLExtendedStreamWriter writer, ModelNode node) throws XMLStreamException {
        String resourceType = this.getResourceType();
        if (!node.has(resourceType)) {
            return;
        }
        ModelNode name = node.get(resourceType);
        for (Property property : name.asPropertyList()) {
            writer.writeStartElement(this.localName);
            writer.writeAttribute(this.getResourceKey(), property.getName());
            ModelNode resourceModel = property.getValue();
            for (SimpleAttributeDefinition attribute : this.attributes()) {
                attribute.marshallAsAttribute(resourceModel, (XMLStreamWriter)writer);
            }
            this.writeChildResources(writer, resourceModel);
            writer.writeEndElement();
        }
    }

    @Override
    public void writeChildResources(XMLExtendedStreamWriter writer, ModelNode node) throws XMLStreamException {
        for (AbstractResourceReaderWriter child : this.children) {
            child.writeResource(writer, node);
        }
    }

    protected String getResourceKey() {
        return "name";
    }

    protected String getResourceType() {
        return this.localName;
    }

    protected SimpleAttributeDefinition[] attributes() {
        return new SimpleAttributeDefinition[0];
    }
}

