/*
 * Decompiled with CFR 0.152.
 */
package org.soulwing.cas.deployment;

import java.net.URI;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.AbstractService;
import org.jboss.msc.value.InjectedValue;
import org.soulwing.cas.extension.Profile;
import org.soulwing.cas.service.AuthenticationService;
import org.soulwing.cas.service.Authenticator;
import org.soulwing.cas.service.AuthenticatorFactory;
import org.soulwing.cas.service.Configuration;
import org.soulwing.cas.service.ProxyCallbackHandler;
import org.soulwing.cas.service.ProxyCallbackHandlerFactory;
import org.soulwing.cas.service.ProxyCallbackResponse;

class DeploymentAuthenticationService
extends AbstractService<AuthenticationService>
implements AuthenticationService {
    private final ProxyCallbackHandler proxyCallbackHandler = ProxyCallbackHandlerFactory.newInstance();
    private final InjectedValue<Profile> profile = new InjectedValue();

    DeploymentAuthenticationService() {
    }

    public Injector<Profile> getProfileInjector() {
        return this.profile;
    }

    public AuthenticationService getValue() throws IllegalStateException {
        return this;
    }

    @Override
    public Authenticator newAuthenticator(String contextPath) {
        return AuthenticatorFactory.newInstance((Configuration)this.profile.getValue(), this.proxyCallbackUrl(contextPath), this.proxyCallbackHandler);
    }

    @Override
    public boolean isProxyCallbackPath(String path) {
        return ((Profile)this.profile.getValue()).getProxyCallbackPath().equals(path);
    }

    @Override
    public ProxyCallbackResponse handleProxyCallback(String query) {
        return this.proxyCallbackHandler.onProxyCallback(query);
    }

    private String proxyCallbackUrl(String contextPath) {
        Configuration config = (Configuration)this.profile.getValue();
        if (config.getProxyCallbackPath() == null) {
            return null;
        }
        URI uri = URI.create(config.getServiceUrl());
        StringBuilder sb = new StringBuilder();
        sb.append(uri.getScheme());
        sb.append("://");
        sb.append(uri.getAuthority());
        sb.append(contextPath);
        String proxyCallbackPath = config.getProxyCallbackPath();
        if (!proxyCallbackPath.startsWith("/") && !contextPath.endsWith("/")) {
            sb.append("/");
        }
        sb.append(proxyCallbackPath);
        return sb.toString();
    }
}

