/*
 * Decompiled with CFR 0.152.
 */
package org.soulwing.cas.deployment;

import java.util.Arrays;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.soulwing.cas.deployment.AppConfiguration;
import org.soulwing.cas.deployment.DescriptorParser;
import org.soulwing.cas.deployment.DescriptorReader;
import org.soulwing.cas.extension.Names;

abstract class AbstractDescriptorReader
implements DescriptorReader {
    private final String namespaceUri;
    private final String localName;
    private final List<AbstractDescriptorReader> children;
    protected DescriptorParser parser;

    public AbstractDescriptorReader(String localName, AbstractDescriptorReader ... children) {
        this(Names.NAMESPACE, localName, children);
    }

    public AbstractDescriptorReader(String namespaceUri, String localName, AbstractDescriptorReader ... children) {
        this.namespaceUri = namespaceUri;
        this.localName = localName;
        this.children = Arrays.asList(children);
    }

    @Override
    public void init(DescriptorParser parser) {
        this.parser = parser;
    }

    protected boolean supports(String namespaceUri, String localName) {
        return this.namespaceUri.equals(namespaceUri) && this.localName.equals(localName);
    }

    @Override
    public void startElement(XMLStreamReader reader, String namespaceUri, String localName, AppConfiguration config) throws XMLStreamException {
        for (AbstractDescriptorReader child : this.children) {
            if (!child.supports(namespaceUri, localName)) continue;
            this.parser.push(child);
            child.attributes(reader, config);
            return;
        }
    }

    @Override
    public void endElement(XMLStreamReader reader, String namespaceUri, String localName, AppConfiguration config) throws XMLStreamException {
        if (!this.namespaceUri.equals(namespaceUri) && this.localName.equals(localName)) {
            throw new XMLStreamException("unexpected end element", reader.getLocation());
        }
        this.parser.pop();
    }

    protected void attributes(XMLStreamReader reader, AppConfiguration config) throws XMLStreamException {
        if (reader.getAttributeCount() > 0) {
            throw new XMLStreamException("unexpected attributes(s)", reader.getLocation());
        }
    }

    @Override
    public void characters(XMLStreamReader reader, AppConfiguration config) throws XMLStreamException {
        if (!reader.getText().trim().isEmpty()) {
            throw new XMLStreamException("unexpected text", reader.getLocation());
        }
    }
}

