/*
 * Decompiled with CFR 0.152.
 */
package org.sonarqube.ws.client.hotspots;

import java.util.stream.Collectors;
import org.sonarqube.ws.Common;
import org.sonarqube.ws.Hotspots;
import org.sonarqube.ws.client.BaseService;
import org.sonarqube.ws.client.GetRequest;
import org.sonarqube.ws.client.PostRequest;
import org.sonarqube.ws.client.RequestWithPayload;
import org.sonarqube.ws.client.RequestWithoutPayload;
import org.sonarqube.ws.client.WsConnector;
import org.sonarqube.ws.client.hotspots.AddCommentRequest;
import org.sonarqube.ws.client.hotspots.AssignRequest;
import org.sonarqube.ws.client.hotspots.ChangeStatusRequest;
import org.sonarqube.ws.client.hotspots.DeleteCommentRequest;
import org.sonarqube.ws.client.hotspots.EditCommentRequest;
import org.sonarqube.ws.client.hotspots.SearchRequest;
import org.sonarqube.ws.client.hotspots.ShowRequest;

public class HotspotsService
extends BaseService {
    public HotspotsService(WsConnector wsConnector) {
        super(wsConnector, "api/hotspots");
    }

    public void addComment(AddCommentRequest request) {
        this.call(((RequestWithPayload)((RequestWithPayload)new PostRequest(this.path("add_comment")).setParam("comment", request.getComment())).setParam("hotspot", request.getHotspot())).setMediaType("application/json")).content();
    }

    public void assign(AssignRequest request) {
        this.call(((RequestWithPayload)((RequestWithPayload)((RequestWithPayload)new PostRequest(this.path("assign")).setParam("assignee", request.getAssignee())).setParam("comment", request.getComment())).setParam("hotspot", request.getHotspot())).setMediaType("application/json")).content();
    }

    public void changeStatus(ChangeStatusRequest request) {
        this.call(((RequestWithPayload)((RequestWithPayload)((RequestWithPayload)((RequestWithPayload)new PostRequest(this.path("change_status")).setParam("comment", request.getComment())).setParam("hotspot", request.getHotspot())).setParam("resolution", request.getResolution())).setParam("status", request.getStatus())).setMediaType("application/json")).content();
    }

    public Common.Comment editComment(EditCommentRequest request) {
        return this.call(((RequestWithPayload)((RequestWithPayload)new PostRequest(this.path("edit_comment")).setParam("comment", request.getComment())).setParam("text", request.getText())).setMediaType("application/json"), Common.Comment.parser());
    }

    public void deleteComment(DeleteCommentRequest request) {
        this.call(((RequestWithPayload)new PostRequest(this.path("delete_comment")).setParam("comment", request.getComment())).setMediaType("application/json")).content();
    }

    public Hotspots.SearchWsResponse search(SearchRequest request) {
        return this.call(((RequestWithoutPayload)((RequestWithoutPayload)((RequestWithoutPayload)((RequestWithoutPayload)((RequestWithoutPayload)((RequestWithoutPayload)((RequestWithoutPayload)((RequestWithoutPayload)((RequestWithoutPayload)((RequestWithoutPayload)new GetRequest(this.path("search")).setParam("branch", request.getBranch())).setParam("hotspots", request.getHotspots() == null ? null : request.getHotspots().stream().collect(Collectors.joining(",")))).setParam("onlyMine", request.getOnlyMine())).setParam("p", request.getP())).setParam("projectKey", request.getProjectKey())).setParam("ps", request.getPs())).setParam("pullRequest", request.getPullRequest())).setParam("resolution", request.getResolution())).setParam("inNewCodePeriod", request.getInNewCodePeriod())).setParam("status", request.getStatus())).setMediaType("application/json"), Hotspots.SearchWsResponse.parser());
    }

    public Hotspots.ShowWsResponse show(ShowRequest request) {
        return this.call(((RequestWithoutPayload)new GetRequest(this.path("show")).setParam("hotspot", request.getHotspot())).setMediaType("application/json"), Hotspots.ShowWsResponse.parser());
    }
}

