/*
 * Decompiled with CFR 0.152.
 */
package org.sonarqube.ws.client;

import java.io.FileInputStream;
import java.io.IOException;
import java.net.Proxy;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.ConnectionSpec;
import okhttp3.Credentials;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.sonarqube.ws.WsUtils;

public class OkHttpClientBuilder {
    private static final String NONE = "NONE";
    private static final String P11KEYSTORE = "PKCS11";
    private static final String PROXY_AUTHORIZATION = "Proxy-Authorization";
    private String userAgent;
    private Proxy proxy;
    private String credentials;
    private String proxyLogin;
    private String proxyPassword;
    private Boolean followRedirects;
    private long connectTimeoutMs = -1L;
    private long readTimeoutMs = -1L;
    private SSLSocketFactory sslSocketFactory = null;
    private X509TrustManager sslTrustManager = null;

    public OkHttpClientBuilder setUserAgent(@Nullable String s) {
        this.userAgent = s;
        return this;
    }

    public OkHttpClientBuilder setSSLSocketFactory(@Nullable SSLSocketFactory sslSocketFactory) {
        this.sslSocketFactory = sslSocketFactory;
        return this;
    }

    public OkHttpClientBuilder setTrustManager(@Nullable X509TrustManager sslTrustManager) {
        this.sslTrustManager = sslTrustManager;
        return this;
    }

    public OkHttpClientBuilder setProxy(@Nullable Proxy proxy) {
        this.proxy = proxy;
        return this;
    }

    public OkHttpClientBuilder setProxyLogin(@Nullable String s) {
        this.proxyLogin = s;
        return this;
    }

    public OkHttpClientBuilder setProxyPassword(@Nullable String s) {
        this.proxyPassword = s;
        return this;
    }

    public OkHttpClientBuilder setConnectTimeoutMs(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("Connect timeout must be positive. Got " + l);
        }
        this.connectTimeoutMs = l;
        return this;
    }

    public OkHttpClientBuilder setCredentials(String credentials) {
        this.credentials = credentials;
        return this;
    }

    public OkHttpClientBuilder setReadTimeoutMs(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("Read timeout must be positive. Got " + l);
        }
        this.readTimeoutMs = l;
        return this;
    }

    public OkHttpClientBuilder setFollowRedirects(Boolean followRedirects) {
        this.followRedirects = followRedirects;
        return this;
    }

    public OkHttpClient build() {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        builder.proxy(this.proxy);
        if (this.connectTimeoutMs >= 0L) {
            builder.connectTimeout(this.connectTimeoutMs, TimeUnit.MILLISECONDS);
        }
        if (this.readTimeoutMs >= 0L) {
            builder.readTimeout(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        builder.addNetworkInterceptor(this::addHeaders);
        if (this.proxyLogin != null) {
            builder.proxyAuthenticator((route, response) -> {
                if (response.request().header(PROXY_AUTHORIZATION) != null) {
                    return null;
                }
                if (407 == response.code()) {
                    String credential = Credentials.basic((String)this.proxyLogin, (String)WsUtils.nullToEmpty(this.proxyPassword), (Charset)StandardCharsets.UTF_8);
                    return response.request().newBuilder().header(PROXY_AUTHORIZATION, credential).build();
                }
                return null;
            });
        }
        if (this.followRedirects != null) {
            builder.followRedirects(this.followRedirects.booleanValue());
            builder.followSslRedirects(this.followRedirects.booleanValue());
        }
        ConnectionSpec tls = new ConnectionSpec.Builder(ConnectionSpec.MODERN_TLS).allEnabledTlsVersions().allEnabledCipherSuites().supportsTlsExtensions(true).build();
        builder.connectionSpecs(Arrays.asList(tls, ConnectionSpec.CLEARTEXT));
        X509TrustManager trustManager = this.sslTrustManager != null ? this.sslTrustManager : OkHttpClientBuilder.systemDefaultTrustManager();
        SSLSocketFactory sslFactory = this.sslSocketFactory != null ? this.sslSocketFactory : OkHttpClientBuilder.systemDefaultSslSocketFactory(trustManager);
        builder.sslSocketFactory(sslFactory, trustManager);
        return builder.build();
    }

    private Response addHeaders(Interceptor.Chain chain) throws IOException {
        Request.Builder newRequest = chain.request().newBuilder();
        if (this.userAgent != null) {
            newRequest.header("User-Agent", this.userAgent);
        }
        if (this.credentials != null) {
            newRequest.header("Authorization", this.credentials);
        }
        return chain.proceed(newRequest.build());
    }

    private static X509TrustManager systemDefaultTrustManager() {
        try {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init((KeyStore)null);
            Object[] trustManagers = trustManagerFactory.getTrustManagers();
            if (trustManagers.length != 1 || !(trustManagers[0] instanceof X509TrustManager)) {
                throw new IllegalStateException("Unexpected default trust managers:" + Arrays.toString(trustManagers));
            }
            return (X509TrustManager)trustManagers[0];
        }
        catch (GeneralSecurityException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static SSLSocketFactory systemDefaultSslSocketFactory(X509TrustManager trustManager) {
        KeyManager[] defaultKeyManager;
        try {
            defaultKeyManager = OkHttpClientBuilder.getDefaultKeyManager();
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to get default key manager", e);
        }
        try {
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(defaultKeyManager, new TrustManager[]{trustManager}, null);
            return sslContext.getSocketFactory();
        }
        catch (GeneralSecurityException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static void logDebug(String msg) {
        boolean debugEnabled = "all".equals(System.getProperty("javax.net.debug"));
        if (debugEnabled) {
            System.out.println(msg);
        }
    }

    private static synchronized KeyManager[] getDefaultKeyManager() throws KeyStoreException, NoSuchProviderException, IOException, CertificateException, NoSuchAlgorithmException, UnrecoverableKeyException {
        char[] passwd;
        String defaultKeyStore = System.getProperty("javax.net.ssl.keyStore", "");
        String defaultKeyStoreType = System.getProperty("javax.net.ssl.keyStoreType", KeyStore.getDefaultType());
        String defaultKeyStoreProvider = System.getProperty("javax.net.ssl.keyStoreProvider", "");
        OkHttpClientBuilder.logDebug("keyStore is : " + defaultKeyStore);
        OkHttpClientBuilder.logDebug("keyStore type is : " + defaultKeyStoreType);
        OkHttpClientBuilder.logDebug("keyStore provider is : " + defaultKeyStoreProvider);
        if (P11KEYSTORE.equals(defaultKeyStoreType) && !NONE.equals(defaultKeyStore)) {
            throw new IllegalArgumentException("if keyStoreType is PKCS11, then keyStore must be NONE");
        }
        KeyStore ks = null;
        String defaultKeyStorePassword = System.getProperty("javax.net.ssl.keyStorePassword", "");
        char[] cArray = passwd = defaultKeyStorePassword.isEmpty() ? null : defaultKeyStorePassword.toCharArray();
        if (!defaultKeyStoreType.isEmpty()) {
            OkHttpClientBuilder.logDebug("init keystore");
            ks = defaultKeyStoreProvider.isEmpty() ? KeyStore.getInstance(defaultKeyStoreType) : KeyStore.getInstance(defaultKeyStoreType, defaultKeyStoreProvider);
            if (!defaultKeyStore.isEmpty() && !NONE.equals(defaultKeyStore)) {
                try (FileInputStream fs = new FileInputStream(defaultKeyStore);){
                    ks.load(fs, passwd);
                }
            } else {
                ks.load(null, passwd);
            }
        }
        OkHttpClientBuilder.logDebug("init keymanager of type " + KeyManagerFactory.getDefaultAlgorithm());
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        if (P11KEYSTORE.equals(defaultKeyStoreType)) {
            kmf.init(ks, null);
        } else {
            kmf.init(ks, passwd);
        }
        return kmf.getKeyManagers();
    }
}

