/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.usertoken.ws;

import com.google.protobuf.Message;
import java.util.List;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.utils.DateUtils;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.user.UserDto;
import org.sonar.db.user.UserTokenDto;
import org.sonar.server.usertoken.ws.UserTokenSupport;
import org.sonar.server.usertoken.ws.UserTokensWsAction;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.UserTokens;

public class SearchAction
implements UserTokensWsAction {
    private final DbClient dbClient;
    private final UserTokenSupport userTokenSupport;

    public SearchAction(DbClient dbClient, UserTokenSupport userTokenSupport) {
        this.dbClient = dbClient;
        this.userTokenSupport = userTokenSupport;
    }

    public void define(WebService.NewController context) {
        WebService.NewAction action = context.createAction("search").setDescription("List the access tokens of a user.<br>The login must exist and active.<br>If the login is set, it requires administration permissions. Otherwise, a token is generated for the authenticated user.").setResponseExample(this.getClass().getResource("search-example.json")).setSince("5.3").setHandler((RequestHandler)this);
        action.createParam("login").setDescription("User login").setExampleValue((Object)"g.hopper");
    }

    public void handle(Request request, Response response) throws Exception {
        UserTokens.SearchWsResponse searchWsResponse = this.doHandle(request);
        WsUtils.writeProtobuf((Message)searchWsResponse, request, response);
    }

    private UserTokens.SearchWsResponse doHandle(Request request) {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            UserDto user = this.userTokenSupport.getUser(dbSession, request);
            List userTokens = this.dbClient.userTokenDao().selectByUser(dbSession, user);
            UserTokens.SearchWsResponse searchWsResponse = SearchAction.buildResponse(user, userTokens);
            return searchWsResponse;
        }
    }

    private static UserTokens.SearchWsResponse buildResponse(UserDto user, List<UserTokenDto> userTokensDto) {
        UserTokens.SearchWsResponse.Builder searchWsResponse = UserTokens.SearchWsResponse.newBuilder();
        UserTokens.SearchWsResponse.UserToken.Builder userTokenBuilder = UserTokens.SearchWsResponse.UserToken.newBuilder();
        searchWsResponse.setLogin(user.getLogin());
        for (UserTokenDto userTokenDto : userTokensDto) {
            userTokenBuilder.clear().setName(userTokenDto.getName()).setCreatedAt(DateUtils.formatDateTime((long)userTokenDto.getCreatedAt()));
            searchWsResponse.addUserTokens(userTokenBuilder);
        }
        return searchWsResponse.build();
    }
}

