/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.usertoken;

import java.util.Optional;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.user.UserTokenDto;
import org.sonar.server.usertoken.TokenGenerator;

public class UserTokenAuthenticator {
    private final TokenGenerator tokenGenerator;
    private final DbClient dbClient;

    public UserTokenAuthenticator(TokenGenerator tokenGenerator, DbClient dbClient) {
        this.tokenGenerator = tokenGenerator;
        this.dbClient = dbClient;
    }

    public Optional<String> authenticate(String token) {
        String tokenHash = this.tokenGenerator.hash(token);
        try (DbSession dbSession = this.dbClient.openSession(false);){
            UserTokenDto userToken = this.dbClient.userTokenDao().selectByTokenHash(dbSession, tokenHash);
            if (userToken == null) {
                Optional<String> optional = Optional.empty();
                return optional;
            }
            Optional<String> optional = Optional.of(userToken.getUserUuid());
            return optional;
        }
    }
}

