/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.user.ws;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.server.ws.Change;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.utils.text.JsonWriter;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.user.UserDto;
import org.sonar.server.exceptions.NotFoundException;
import org.sonar.server.user.UpdateUser;
import org.sonar.server.user.UserSession;
import org.sonar.server.user.UserUpdater;
import org.sonar.server.user.ws.EmailValidator;
import org.sonar.server.user.ws.UserJsonWriter;
import org.sonar.server.user.ws.UsersWsAction;

public class UpdateAction
implements UsersWsAction {
    private final UserUpdater userUpdater;
    private final UserSession userSession;
    private final UserJsonWriter userWriter;
    private final DbClient dbClient;

    public UpdateAction(UserUpdater userUpdater, UserSession userSession, UserJsonWriter userWriter, DbClient dbClient) {
        this.userUpdater = userUpdater;
        this.userSession = userSession;
        this.userWriter = userWriter;
        this.dbClient = dbClient;
    }

    public void define(WebService.NewController controller) {
        WebService.NewAction action = controller.createAction("update").setDescription("Update a user. If a deactivated user account exists with the given login, it will be reactivated. Requires Administer System permission").setSince("3.7").setChangelog(new Change[]{new Change("5.2", "User's password can only be changed using the 'change_password' action.")}).setPost(true).setHandler((RequestHandler)this).setResponseExample(this.getClass().getResource("update-example.json"));
        action.createParam("login").setRequired(true).setMaximumLength(Integer.valueOf(255)).setDescription("User login").setExampleValue((Object)"myuser");
        action.createParam("name").setMaximumLength(Integer.valueOf(200)).setDescription("User name").setExampleValue((Object)"My Name");
        action.createParam("email").setMaximumLength(Integer.valueOf(100)).setDescription("User email").setExampleValue((Object)"myname@email.com");
        action.createParam("scmAccounts").setDescription("This parameter is deprecated, please use '%s' instead", new Object[]{"scmAccount"}).setDeprecatedKey("scm_accounts", "6.0").setDeprecatedSince("6.1").setExampleValue((Object)"myscmaccount1,myscmaccount2");
        action.createParam("scmAccount").setDescription("SCM accounts. To set several values, the parameter must be called once for each value.").setExampleValue((Object)"scmAccount=firstValue&scmAccount=secondValue&scmAccount=thirdValue");
    }

    public void handle(Request request, Response response) throws Exception {
        this.userSession.checkLoggedIn().checkIsSystemAdministrator();
        UpdateRequest updateRequest = UpdateAction.toWsRequest(request);
        Preconditions.checkArgument((boolean)EmailValidator.isValidIfPresent(updateRequest.getEmail()), (String)"Email '%s' is not valid", (Object[])new Object[]{updateRequest.getEmail()});
        try (DbSession dbSession = this.dbClient.openSession(false);){
            UserDto user = this.getUser(dbSession, updateRequest.getLogin());
            this.doHandle(dbSession, updateRequest);
            this.writeUser(dbSession, response, user.getUuid());
        }
    }

    private void doHandle(DbSession dbSession, UpdateRequest request) {
        String login = request.getLogin();
        UserDto user = this.getUser(dbSession, login);
        UpdateUser updateUser = new UpdateUser();
        if (request.getName() != null) {
            updateUser.setName(request.getName());
        }
        if (request.getEmail() != null) {
            updateUser.setEmail(Strings.emptyToNull((String)request.getEmail()));
        }
        if (!request.getScmAccounts().isEmpty()) {
            updateUser.setScmAccounts(request.getScmAccounts());
        }
        this.userUpdater.updateAndCommit(dbSession, user, updateUser, u -> {}, new UserDto[0]);
    }

    private UserDto getUser(DbSession dbSession, String login) {
        UserDto user = this.dbClient.userDao().selectByLogin(dbSession, login);
        if (user == null || !user.isActive()) {
            throw new NotFoundException(String.format("User '%s' doesn't exist", login));
        }
        return user;
    }

    private void writeUser(DbSession dbSession, Response response, String uuid) {
        try (JsonWriter json = response.newJsonWriter();){
            json.beginObject();
            json.name("user");
            UserDto user = this.dbClient.userDao().selectByUuid(dbSession, uuid);
            Preconditions.checkState((user != null ? 1 : 0) != 0, (String)"User with uuid '%s' doesn't exist", (Object[])new Object[]{uuid});
            HashSet<String> groups = new HashSet<String>(this.dbClient.groupMembershipDao().selectGroupsByLogins(dbSession, Collections.singletonList(uuid)).get((Object)uuid));
            this.userWriter.write(json, user, groups, UserJsonWriter.FIELDS);
            json.endObject().close();
        }
    }

    private static UpdateRequest toWsRequest(Request request) {
        return UpdateRequest.builder().setLogin(request.mandatoryParam("login")).setName(request.param("name")).setEmail(request.param("email")).setScmAccounts(UpdateAction.getScmAccounts(request)).build();
    }

    private static List<String> getScmAccounts(Request request) {
        if (request.hasParam("scmAccount")) {
            return new ArrayList<String>(request.multiParam("scmAccount"));
        }
        List oldScmAccounts = request.paramAsStrings("scmAccounts");
        return oldScmAccounts != null ? oldScmAccounts : new ArrayList();
    }

    private static class Builder {
        private String login;
        private String name;
        private String email;
        private List<String> scmAccounts = Collections.emptyList();

        private Builder() {
        }

        public Builder setLogin(String login) {
            this.login = login;
            return this;
        }

        public Builder setName(@Nullable String name) {
            this.name = name;
            return this;
        }

        public Builder setEmail(@Nullable String email) {
            this.email = email;
            return this;
        }

        public Builder setScmAccounts(List<String> scmAccounts) {
            this.scmAccounts = scmAccounts;
            return this;
        }

        public UpdateRequest build() {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)this.login) ? 1 : 0) != 0, (Object)"Login is mandatory and must not be empty");
            return new UpdateRequest(this);
        }
    }

    private static class UpdateRequest {
        private final String login;
        private final String name;
        private final String email;
        private final List<String> scmAccounts;

        private UpdateRequest(Builder builder) {
            this.login = builder.login;
            this.name = builder.name;
            this.email = builder.email;
            this.scmAccounts = builder.scmAccounts;
        }

        public String getLogin() {
            return this.login;
        }

        @CheckForNull
        public String getName() {
            return this.name;
        }

        @CheckForNull
        public String getEmail() {
            return this.email;
        }

        public List<String> getScmAccounts() {
            return this.scmAccounts;
        }

        public static Builder builder() {
            return new Builder();
        }
    }
}

