/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.user;

import java.util.Collection;
import java.util.List;
import javax.annotation.CheckForNull;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.permission.OrganizationPermission;
import org.sonar.db.user.GroupDto;

public interface UserSession {
    @CheckForNull
    public String getLogin();

    @CheckForNull
    public String getUuid();

    @CheckForNull
    public String getName();

    @CheckForNull
    public Integer getUserId();

    public Collection<GroupDto> getGroups();

    public boolean isLoggedIn();

    public boolean isRoot();

    public UserSession checkIsRoot();

    public UserSession checkLoggedIn();

    public boolean hasPermission(OrganizationPermission var1, OrganizationDto var2);

    public boolean hasPermission(OrganizationPermission var1, String var2);

    public UserSession checkPermission(OrganizationPermission var1, OrganizationDto var2);

    public UserSession checkPermission(OrganizationPermission var1, String var2);

    public boolean hasComponentPermission(String var1, ComponentDto var2);

    @Deprecated
    public boolean hasComponentUuidPermission(String var1, String var2);

    public List<ComponentDto> keepAuthorizedComponents(String var1, Collection<ComponentDto> var2);

    public UserSession checkComponentPermission(String var1, ComponentDto var2);

    @Deprecated
    public UserSession checkComponentUuidPermission(String var1, String var2);

    public boolean isSystemAdministrator();

    public UserSession checkIsSystemAdministrator();
}

