/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.source.ws;

import com.google.common.io.Resources;
import java.util.Optional;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.utils.text.JsonWriter;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.server.component.ComponentFinder;
import org.sonar.server.source.SourceService;
import org.sonar.server.source.ws.SourcesWsAction;
import org.sonar.server.user.UserSession;

public class IndexAction
implements SourcesWsAction {
    private final DbClient dbClient;
    private final SourceService sourceService;
    private final UserSession userSession;
    private final ComponentFinder componentFinder;

    public IndexAction(DbClient dbClient, SourceService sourceService, UserSession userSession, ComponentFinder componentFinder) {
        this.dbClient = dbClient;
        this.sourceService = sourceService;
        this.userSession = userSession;
        this.componentFinder = componentFinder;
    }

    public void define(WebService.NewController controller) {
        WebService.NewAction action = controller.createAction("index").setDescription("Get source code as line number / text pairs. Require See Source Code permission on file").setSince("5.0").setResponseExample(Resources.getResource(this.getClass(), (String)"example-index.json")).setInternal(true).setHandler((RequestHandler)this);
        action.createParam("resource").setRequired(true).setDescription("File key").setExampleValue((Object)"my_project:/src/foo/Bar.php");
        action.createParam("from").setDefaultValue((Object)1).setDescription("First line");
        action.createParam("to").setDescription("Last line (excluded). If not specified, all lines are returned until end of file");
    }

    public void handle(Request request, Response response) {
        String fileKey = request.mandatoryParam("resource");
        int from = request.mandatoryParamAsInt("from");
        Integer to = request.paramAsInt("to");
        try (DbSession session = this.dbClient.openSession(false);){
            ComponentDto component = this.componentFinder.getByKey(session, fileKey);
            this.userSession.checkComponentPermission("codeviewer", component);
            Optional<Iterable<String>> lines = this.sourceService.getLinesAsRawText(session, component.uuid(), from, to == null ? Integer.MAX_VALUE : to - 1);
            try (JsonWriter json = response.newJsonWriter();){
                json.beginArray().beginObject();
                if (lines.isPresent()) {
                    int lineCounter = from;
                    for (String line : lines.get()) {
                        json.prop(String.valueOf(lineCounter), line);
                        ++lineCounter;
                    }
                }
                json.endObject().endArray();
            }
        }
    }
}

