/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.settings;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.sonar.api.config.Configuration;
import org.sonar.api.config.Settings;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.server.settings.ChildSettings;
import org.sonar.server.settings.ProjectConfigurationLoader;

public class ProjectConfigurationLoaderImpl
implements ProjectConfigurationLoader {
    private final Settings globalSettings;
    private final DbClient dbClient;

    public ProjectConfigurationLoaderImpl(Settings globalSettings, DbClient dbClient) {
        this.globalSettings = globalSettings;
        this.dbClient = dbClient;
    }

    @Override
    public Map<String, Configuration> loadProjectConfigurations(DbSession dbSession, Set<ComponentDto> projects) {
        Set<String> mainBranchDbKeys = projects.stream().map(ComponentDto::getKey).collect(Collectors.toSet());
        Map<String, ChildSettings> mainBranchSettingsByDbKey = this.loadMainBranchConfigurations(dbSession, mainBranchDbKeys);
        return (Map)projects.stream().collect(MoreCollectors.uniqueIndex(ComponentDto::uuid, component -> {
            if (component.getDbKey().equals(component.getKey())) {
                return ((ChildSettings)((Object)((Object)mainBranchSettingsByDbKey.get(component.getKey())))).asConfiguration();
            }
            ChildSettings settings = new ChildSettings((Settings)mainBranchSettingsByDbKey.get(component.getKey()));
            this.dbClient.propertiesDao().selectProjectProperties(dbSession, component.getDbKey()).forEach(property -> settings.setProperty(property.getKey(), property.getValue()));
            return settings.asConfiguration();
        }));
    }

    private Map<String, ChildSettings> loadMainBranchConfigurations(DbSession dbSession, Set<String> dbKeys) {
        return (Map)dbKeys.stream().collect(MoreCollectors.uniqueIndex(Function.identity(), dbKey -> {
            ChildSettings settings = new ChildSettings(this.globalSettings);
            List propertyDtos = this.dbClient.propertiesDao().selectProjectProperties(dbSession, dbKey);
            propertyDtos.forEach(property -> settings.setProperty(property.getKey(), property.getValue()));
            return settings;
        }));
    }
}

