/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.rule.ws;

import com.google.common.io.Resources;
import com.google.protobuf.Message;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.rule.RuleDto;
import org.sonar.server.exceptions.NotFoundException;
import org.sonar.server.rule.ws.ActiveRuleCompleter;
import org.sonar.server.rule.ws.RuleMapper;
import org.sonar.server.rule.ws.RuleWsSupport;
import org.sonar.server.rule.ws.RulesWsAction;
import org.sonar.server.rule.ws.SearchAction;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.Rules;

public class ShowAction
implements RulesWsAction {
    public static final String PARAM_KEY = "key";
    public static final String PARAM_ACTIVES = "actives";
    public static final String PARAM_ORGANIZATION = "organization";
    private final DbClient dbClient;
    private final RuleMapper mapper;
    private final ActiveRuleCompleter activeRuleCompleter;
    private final RuleWsSupport ruleWsSupport;

    public ShowAction(DbClient dbClient, RuleMapper mapper, ActiveRuleCompleter activeRuleCompleter, RuleWsSupport ruleWsSupport) {
        this.dbClient = dbClient;
        this.activeRuleCompleter = activeRuleCompleter;
        this.mapper = mapper;
        this.ruleWsSupport = ruleWsSupport;
    }

    public void define(WebService.NewController controller) {
        WebService.NewAction action = controller.createAction("show").setDescription("Get detailed information about a rule<br>Since 5.5, following fields in the response have been deprecated :<ul><li>\"effortToFixDescription\" becomes \"gapDescription\"</li><li>\"debtRemFnCoeff\" becomes \"remFnGapMultiplier\"</li><li>\"defaultDebtRemFnCoeff\" becomes \"defaultRemFnGapMultiplier\"</li><li>\"debtRemFnOffset\" becomes \"remFnBaseEffort\"</li><li>\"defaultDebtRemFnOffset\" becomes \"defaultRemFnBaseEffort\"</li><li>\"debtOverloaded\" becomes \"remFnOverloaded\"</li></ul>In 7.1, the field 'scope' has been added.").setSince("4.2").setResponseExample(Resources.getResource(this.getClass(), (String)"example-show.json")).setHandler((RequestHandler)this);
        action.createParam(PARAM_KEY).setDescription("Rule key").setRequired(true).setExampleValue((Object)"javascript:EmptyBlock");
        action.createParam(PARAM_ACTIVES).setDescription("Show rule's activations for all profiles (\"active rules\")").setBooleanPossibleValues().setDefaultValue((Object)false);
        action.createParam(PARAM_ORGANIZATION).setDescription("Organization key").setRequired(false).setInternal(true).setExampleValue((Object)"my-org").setSince("6.4");
    }

    public void handle(Request request, Response response) throws Exception {
        RuleKey key = RuleKey.parse((String)request.mandatoryParam(PARAM_KEY));
        try (DbSession dbSession = this.dbClient.openSession(false);){
            OrganizationDto organization = this.ruleWsSupport.getOrganizationByKey(dbSession, request.param(PARAM_ORGANIZATION));
            RuleDto rule = (RuleDto)this.dbClient.ruleDao().selectByKey(dbSession, organization, key).orElseThrow(() -> new NotFoundException(String.format("Rule not found: %s", key)));
            List templateRules = Optional.ofNullable(rule.getTemplateId()).flatMap(templateId -> this.dbClient.ruleDao().selectDefinitionById((long)rule.getTemplateId().intValue(), dbSession)).map(Collections::singletonList).orElseGet(Collections::emptyList);
            List ruleParameters = this.dbClient.ruleDao().selectRuleParamsByRuleIds(dbSession, Collections.singletonList(rule.getId()));
            Rules.ShowResponse showResponse = this.buildResponse(dbSession, organization, request, new SearchAction.SearchResult().setRules(Collections.singletonList(rule)).setTemplateRules(templateRules).setRuleParameters(ruleParameters).setTotal(1L));
            WsUtils.writeProtobuf((Message)showResponse, request, response);
        }
    }

    private Rules.ShowResponse buildResponse(DbSession dbSession, OrganizationDto organization, Request request, SearchAction.SearchResult searchResult) {
        Rules.ShowResponse.Builder responseBuilder = Rules.ShowResponse.newBuilder();
        RuleDto rule = searchResult.getRules().get(0);
        responseBuilder.setRule(this.mapper.toWsRule(rule.getDefinition(), searchResult, Collections.emptySet(), rule.getMetadata(), this.ruleWsSupport.getUsersByUuid(dbSession, searchResult.getRules())));
        if (request.mandatoryParamAsBoolean(PARAM_ACTIVES)) {
            this.activeRuleCompleter.completeShow(dbSession, organization, rule.getDefinition()).forEach(arg_0 -> ((Rules.ShowResponse.Builder)responseBuilder).addActives(arg_0));
        }
        return responseBuilder.build();
    }
}

