/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.rule.index;

import com.google.common.base.Preconditions;
import java.util.Optional;
import javax.annotation.Nullable;
import org.sonar.db.organization.OrganizationDto;

public class RuleExtensionScope {
    private static final String FAKE_UUID_FOR_SYSTEM = "system";
    private final Optional<String> organizationUuid;

    private RuleExtensionScope(@Nullable String organizationUuid) {
        this.organizationUuid = Optional.ofNullable(organizationUuid);
    }

    public static RuleExtensionScope system() {
        return new RuleExtensionScope(null);
    }

    public static RuleExtensionScope organization(OrganizationDto organization) {
        return RuleExtensionScope.organization(organization.getUuid());
    }

    public static RuleExtensionScope organization(String organizationUuid) {
        Preconditions.checkArgument((!FAKE_UUID_FOR_SYSTEM.equals(organizationUuid) ? 1 : 0) != 0, (String)"The organization uuid '%s' is reserved for to store system tags in the rules index.", (Object[])new Object[]{FAKE_UUID_FOR_SYSTEM});
        return new RuleExtensionScope(organizationUuid);
    }

    public String getScope() {
        return this.organizationUuid.orElse(FAKE_UUID_FOR_SYSTEM);
    }

    public static RuleExtensionScope parse(String scope) {
        if (FAKE_UUID_FOR_SYSTEM.equals(scope)) {
            return RuleExtensionScope.system();
        }
        return new RuleExtensionScope(scope);
    }
}

