/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.qualityprofile.ws;

import com.google.common.base.Preconditions;
import com.google.protobuf.Message;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.resources.Language;
import org.sonar.api.resources.Languages;
import org.sonar.api.rule.RuleStatus;
import org.sonar.api.server.ws.Change;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.utils.DateUtils;
import org.sonar.core.util.Protobuf;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.permission.OrganizationPermission;
import org.sonar.db.qualityprofile.ActiveRuleCountQuery;
import org.sonar.db.qualityprofile.QProfileDto;
import org.sonar.db.user.UserDto;
import org.sonar.server.component.ComponentFinder;
import org.sonar.server.exceptions.NotFoundException;
import org.sonar.server.qualityprofile.ws.QProfileWsAction;
import org.sonar.server.qualityprofile.ws.QProfileWsSupport;
import org.sonar.server.qualityprofile.ws.SearchData;
import org.sonar.server.user.UserSession;
import org.sonar.server.util.LanguageParamUtils;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.Qualityprofiles;

public class SearchAction
implements QProfileWsAction {
    private static final Comparator<QProfileDto> Q_PROFILE_COMPARATOR = Comparator.comparing(QProfileDto::getLanguage).thenComparing(QProfileDto::getName);
    private final UserSession userSession;
    private final Languages languages;
    private final DbClient dbClient;
    private final QProfileWsSupport wsSupport;
    private final ComponentFinder componentFinder;

    public SearchAction(UserSession userSession, Languages languages, DbClient dbClient, QProfileWsSupport wsSupport, ComponentFinder componentFinder) {
        this.userSession = userSession;
        this.languages = languages;
        this.dbClient = dbClient;
        this.wsSupport = wsSupport;
        this.componentFinder = componentFinder;
    }

    public void define(WebService.NewController controller) {
        WebService.NewAction action = controller.createAction("search").setSince("5.2").setDescription("Search quality profiles").setHandler((RequestHandler)this).setChangelog(new Change[]{new Change("6.5", String.format("The parameters '%s', '%s' and '%s' can be combined without any constraint", "defaults", "project", "language")), new Change("6.6", "Add available actions 'edit', 'copy' and 'setAsDefault' and global action 'create'"), new Change("7.0", "Add available actions 'delete' and 'associateProjects'")}).setResponseExample(this.getClass().getResource("search-example.json"));
        QProfileWsSupport.createOrganizationParam(action).setSince("6.4");
        action.createParam("defaults").setDescription("If set to true, return only the quality profiles marked as default for each language").setDefaultValue((Object)false).setBooleanPossibleValues();
        action.createParam("project").setDescription("Project key").setDeprecatedKey("projectKey", "6.5").setExampleValue((Object)"my_project");
        action.createParam("language").setDescription("Language key. If provided, only profiles for the given language are returned.").setPossibleValues(LanguageParamUtils.getLanguageKeys(this.languages));
        action.createParam("qualityProfile").setDescription("Quality profile name").setDeprecatedKey("profileName", "6.6").setExampleValue((Object)"SonarQube Way");
    }

    public void handle(Request request, Response response) throws Exception {
        Qualityprofiles.SearchWsResponse searchWsResponse = this.doHandle(SearchAction.toSearchWsRequest(request));
        WsUtils.writeProtobuf((Message)searchWsResponse, request, response);
    }

    private static SearchRequest toSearchWsRequest(Request request) {
        return new SearchRequest().setOrganizationKey(request.param("organization")).setProjectKey(request.param("project")).setQualityProfile(request.param("qualityProfile")).setDefaults(request.paramAsBoolean("defaults")).setLanguage(request.param("language"));
    }

    private Qualityprofiles.SearchWsResponse doHandle(SearchRequest request) {
        SearchData data = this.load(request);
        return this.buildResponse(data);
    }

    private SearchData load(SearchRequest request) {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            OrganizationDto organization = this.wsSupport.getOrganizationByKey(dbSession, request.getOrganizationKey());
            ComponentDto project = this.findProject(dbSession, organization, request);
            List defaultProfiles = this.dbClient.qualityProfileDao().selectDefaultProfiles(dbSession, organization, this.getLanguageKeys());
            List<String> editableProfiles = this.searchEditableProfiles(dbSession, organization);
            List<QProfileDto> profiles = this.searchProfiles(dbSession, request, organization, defaultProfiles, project);
            ActiveRuleCountQuery.Builder builder = ActiveRuleCountQuery.builder().setOrganization(organization);
            SearchData searchData = new SearchData().setOrganization(organization).setProfiles(profiles).setActiveRuleCountByProfileKey(this.dbClient.activeRuleDao().countActiveRulesByQuery(dbSession, builder.setProfiles(profiles).build())).setActiveDeprecatedRuleCountByProfileKey(this.dbClient.activeRuleDao().countActiveRulesByQuery(dbSession, builder.setProfiles(profiles).setRuleStatus(RuleStatus.DEPRECATED).build())).setProjectCountByProfileKey(this.dbClient.qualityProfileDao().countProjectsByOrganizationAndProfiles(dbSession, organization, profiles)).setDefaultProfileKeys(defaultProfiles).setEditableProfileKeys(editableProfiles);
            return searchData;
        }
    }

    @CheckForNull
    private ComponentDto findProject(DbSession dbSession, OrganizationDto organization, SearchRequest request) {
        if (request.getProjectKey() == null) {
            return null;
        }
        ComponentDto project = this.componentFinder.getByKey(dbSession, request.getProjectKey());
        if (!project.getOrganizationUuid().equals(organization.getUuid())) {
            throw new NotFoundException(String.format("Component key '%s' not found", project.getDbKey()));
        }
        if (project.isRoot()) {
            return project;
        }
        ComponentDto component = (ComponentDto)this.dbClient.componentDao().selectByUuid(dbSession, project.projectUuid()).orNull();
        Preconditions.checkState((component != null ? 1 : 0) != 0, (String)"Project uuid of component uuid '%s' does not exist", (Object[])new Object[]{project.uuid()});
        return component;
    }

    private List<String> searchEditableProfiles(DbSession dbSession, OrganizationDto organization) {
        if (!this.userSession.isLoggedIn()) {
            return Collections.emptyList();
        }
        String login = this.userSession.getLogin();
        UserDto user = this.dbClient.userDao().selectActiveUserByLogin(dbSession, login);
        Preconditions.checkState((user != null ? 1 : 0) != 0, (String)"User with login '%s' is not found'", (Object[])new Object[]{login});
        return (List)Stream.concat(this.dbClient.qProfileEditUsersDao().selectQProfileUuidsByOrganizationAndUser(dbSession, organization, user).stream(), this.dbClient.qProfileEditGroupsDao().selectQProfileUuidsByOrganizationAndGroups(dbSession, organization, this.userSession.getGroups()).stream()).collect(MoreCollectors.toList());
    }

    private List<QProfileDto> searchProfiles(DbSession dbSession, SearchRequest request, OrganizationDto organization, List<QProfileDto> defaultProfiles, @Nullable ComponentDto project) {
        Collection<QProfileDto> profiles = this.selectAllProfiles(dbSession, organization);
        return profiles.stream().filter(this.hasLanguagePlugin()).filter(SearchAction.byLanguage(request)).filter(SearchAction.byName(request)).filter(SearchAction.byDefault(request, defaultProfiles)).filter(this.byProject(dbSession, project, defaultProfiles)).sorted(Q_PROFILE_COMPARATOR).collect(Collectors.toList());
    }

    private Predicate<QProfileDto> hasLanguagePlugin() {
        return p -> this.languages.get(p.getLanguage()) != null;
    }

    private static Predicate<QProfileDto> byName(SearchRequest request) {
        return p -> request.getQualityProfile() == null || Objects.equals(p.getName(), request.getQualityProfile());
    }

    private static Predicate<QProfileDto> byLanguage(SearchRequest request) {
        return p -> request.getLanguage() == null || Objects.equals(p.getLanguage(), request.getLanguage());
    }

    private static Predicate<QProfileDto> byDefault(SearchRequest request, List<QProfileDto> defaultProfiles) {
        Set defaultProfileUuids = defaultProfiles.stream().map(QProfileDto::getKee).collect(Collectors.toSet());
        return p -> !request.getDefaults() || defaultProfileUuids.contains(p.getKee());
    }

    private Predicate<QProfileDto> byProject(DbSession dbSession, @Nullable ComponentDto project, List<QProfileDto> defaultProfiles) {
        if (project == null) {
            return p -> true;
        }
        Map effectiveProfiles = defaultProfiles.stream().collect(Collectors.toMap(QProfileDto::getLanguage, Function.identity()));
        effectiveProfiles.putAll((Map)this.dbClient.qualityProfileDao().selectAssociatedToProjectUuidAndLanguages(dbSession, project, this.getLanguageKeys()).stream().collect(MoreCollectors.uniqueIndex(QProfileDto::getLanguage)));
        return p -> Objects.equals(p.getKee(), ((QProfileDto)effectiveProfiles.get(p.getLanguage())).getKee());
    }

    private Collection<QProfileDto> selectAllProfiles(DbSession dbSession, OrganizationDto organization) {
        return this.dbClient.qualityProfileDao().selectOrderedByOrganizationUuid(dbSession, organization);
    }

    private Set<String> getLanguageKeys() {
        return (Set)Arrays.stream(this.languages.all()).map(Language::getKey).collect(MoreCollectors.toSet());
    }

    private Qualityprofiles.SearchWsResponse buildResponse(SearchData data) {
        List<QProfileDto> profiles = data.getProfiles();
        Map<String, QProfileDto> profilesByKey = profiles.stream().collect(Collectors.toMap(QProfileDto::getKee, Function.identity()));
        boolean isGlobalQProfileAdmin = this.userSession.hasPermission(OrganizationPermission.ADMINISTER_QUALITY_PROFILES, data.getOrganization());
        Qualityprofiles.SearchWsResponse.Builder response = Qualityprofiles.SearchWsResponse.newBuilder();
        response.setActions(Qualityprofiles.SearchWsResponse.Actions.newBuilder().setCreate(isGlobalQProfileAdmin));
        for (QProfileDto profile : profiles) {
            Qualityprofiles.SearchWsResponse.QualityProfile.Builder profileBuilder = response.addProfilesBuilder();
            String profileKey = profile.getKee();
            Protobuf.setNullable((Object)profile.getOrganizationUuid(), o -> profileBuilder.setOrganization(data.getOrganization().getKey()));
            profileBuilder.setKey(profileKey);
            Protobuf.setNullable((Object)profile.getName(), arg_0 -> ((Qualityprofiles.SearchWsResponse.QualityProfile.Builder)profileBuilder).setName(arg_0));
            Protobuf.setNullable((Object)profile.getRulesUpdatedAt(), arg_0 -> ((Qualityprofiles.SearchWsResponse.QualityProfile.Builder)profileBuilder).setRulesUpdatedAt(arg_0));
            Protobuf.setNullable((Object)profile.getLastUsed(), last -> profileBuilder.setLastUsed(DateUtils.formatDateTime((long)last)));
            Protobuf.setNullable((Object)profile.getUserUpdatedAt(), userUpdatedAt -> profileBuilder.setUserUpdatedAt(DateUtils.formatDateTime((long)userUpdatedAt)));
            profileBuilder.setActiveRuleCount(data.getActiveRuleCount(profileKey));
            profileBuilder.setActiveDeprecatedRuleCount(data.getActiveDeprecatedRuleCount(profileKey));
            boolean isDefault = data.isDefault(profile);
            profileBuilder.setIsDefault(isDefault);
            if (!isDefault) {
                profileBuilder.setProjectCount(data.getProjectCount(profileKey));
            }
            this.writeLanguageFields(profileBuilder, profile);
            SearchAction.writeParentFields(profileBuilder, profile, profilesByKey);
            profileBuilder.setIsInherited(profile.getParentKee() != null);
            profileBuilder.setIsBuiltIn(profile.isBuiltIn());
            profileBuilder.setActions(Qualityprofiles.SearchWsResponse.QualityProfile.Actions.newBuilder().setEdit(!profile.isBuiltIn() && (isGlobalQProfileAdmin || data.isEditable(profile))).setSetAsDefault(!isDefault && isGlobalQProfileAdmin).setCopy(isGlobalQProfileAdmin).setDelete(!isDefault && !profile.isBuiltIn() && (isGlobalQProfileAdmin || data.isEditable(profile))).setAssociateProjects(!isDefault && (isGlobalQProfileAdmin || data.isEditable(profile))));
        }
        return response.build();
    }

    private void writeLanguageFields(Qualityprofiles.SearchWsResponse.QualityProfile.Builder profileBuilder, QProfileDto profile) {
        String languageKey = profile.getLanguage();
        if (languageKey == null) {
            return;
        }
        profileBuilder.setLanguage(languageKey);
        String languageName = this.languages.get(languageKey).getName();
        if (languageName != null) {
            profileBuilder.setLanguageName(languageName);
        }
    }

    private static void writeParentFields(Qualityprofiles.SearchWsResponse.QualityProfile.Builder profileBuilder, QProfileDto profile, Map<String, QProfileDto> profilesByKey) {
        String parentKey = profile.getParentKee();
        if (parentKey == null) {
            return;
        }
        profileBuilder.setParentKey(parentKey);
        QProfileDto parent = profilesByKey.get(parentKey);
        if (parent != null && parent.getName() != null) {
            profileBuilder.setParentName(parent.getName());
        }
    }

    private static class SearchRequest {
        private String organizationKey;
        private boolean defaults;
        private String language;
        private String qualityProfile;
        private String projectKey;

        private SearchRequest() {
        }

        public String getOrganizationKey() {
            return this.organizationKey;
        }

        public SearchRequest setOrganizationKey(String organizationKey) {
            this.organizationKey = organizationKey;
            return this;
        }

        public boolean getDefaults() {
            return this.defaults;
        }

        public SearchRequest setDefaults(boolean defaults) {
            this.defaults = defaults;
            return this;
        }

        @CheckForNull
        public String getLanguage() {
            return this.language;
        }

        public SearchRequest setLanguage(@Nullable String language) {
            this.language = language;
            return this;
        }

        @CheckForNull
        public String getQualityProfile() {
            return this.qualityProfile;
        }

        public SearchRequest setQualityProfile(@Nullable String qualityProfile) {
            this.qualityProfile = qualityProfile;
            return this;
        }

        @CheckForNull
        public String getProjectKey() {
            return this.projectKey;
        }

        public SearchRequest setProjectKey(@Nullable String projectKey) {
            this.projectKey = projectKey;
            return this;
        }
    }
}

