/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.qualityprofile;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.rule.RuleKey;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.qualityprofile.ActiveRuleDto;
import org.sonar.db.qualityprofile.ActiveRuleKey;
import org.sonar.db.qualityprofile.ActiveRuleParamDto;
import org.sonar.db.qualityprofile.QProfileDto;
import org.sonar.db.qualityprofile.RulesProfileDto;
import org.sonar.db.rule.RuleDefinitionDto;
import org.sonar.db.rule.RuleParamDto;
import org.sonar.server.qualityprofile.RuleActivation;
import org.sonar.server.ws.WsUtils;

class RuleActivationContext {
    private final long date;
    private RulesProfileDto baseRulesProfile;
    @Nullable
    private QProfileDto baseProfile;
    private final Map<String, QProfileDto> profilesByUuid = new HashMap<String, QProfileDto>();
    private final ListMultimap<String, QProfileDto> profilesByParentUuid = ArrayListMultimap.create();
    private final List<QProfileDto> builtInAliases = new ArrayList<QProfileDto>();
    private final Map<Integer, RuleWrapper> rulesById;
    private final Map<ActiveRuleKey, ActiveRuleWrapper> activeRulesByKey;
    private boolean cascading = false;
    private RulesProfileDto currentRulesProfile;
    @Nullable
    private QProfileDto currentProfile;
    @Nullable
    private RuleWrapper currentRule;
    @Nullable
    private ActiveRuleWrapper currentActiveRule;
    @Nullable
    private ActiveRuleWrapper currentParentActiveRule;

    private RuleActivationContext(Builder builder) {
        this.date = builder.date;
        this.rulesById = Maps.newHashMapWithExpectedSize((int)builder.rules.size());
        ListMultimap paramsByRuleId = (ListMultimap)builder.ruleParams.stream().collect(MoreCollectors.index(RuleParamDto::getRuleId));
        for (RuleDefinitionDto rule : builder.rules) {
            RuleWrapper wrapper = new RuleWrapper(rule, paramsByRuleId.get((Object)rule.getId()));
            this.rulesById.put(rule.getId(), wrapper);
        }
        this.baseProfile = builder.baseProfile;
        this.baseRulesProfile = builder.baseRulesProfile;
        for (QProfileDto profile : builder.profiles) {
            this.profilesByUuid.put(profile.getKee(), profile);
            if (profile.isBuiltIn()) {
                this.builtInAliases.add(profile);
                continue;
            }
            if (profile.getParentKee() == null) continue;
            this.profilesByParentUuid.put((Object)profile.getParentKee(), (Object)profile);
        }
        this.activeRulesByKey = Maps.newHashMapWithExpectedSize((int)builder.activeRules.size());
        ListMultimap paramsByActiveRuleId = (ListMultimap)builder.activeRuleParams.stream().collect(MoreCollectors.index(ActiveRuleParamDto::getActiveRuleId));
        for (ActiveRuleDto activeRule : builder.activeRules) {
            ActiveRuleWrapper wrapper = new ActiveRuleWrapper(activeRule, paramsByActiveRuleId.get((Object)activeRule.getId()));
            this.activeRulesByKey.put(activeRule.getKey(), wrapper);
        }
    }

    long getDate() {
        return this.date;
    }

    RuleWrapper getRule() {
        return this.currentRule;
    }

    @CheckForNull
    String getRequestedParamValue(RuleActivation request, String key) {
        if (this.currentRule.rule.isCustomRule()) {
            return null;
        }
        return request.getParameter(key);
    }

    boolean hasRequestedParamValue(RuleActivation request, String key) {
        return request.hasParameter(key);
    }

    RulesProfileDto getRulesProfile() {
        return this.currentRulesProfile;
    }

    @CheckForNull
    ActiveRuleWrapper getActiveRule() {
        return this.currentActiveRule;
    }

    @CheckForNull
    ActiveRuleWrapper getParentActiveRule() {
        return this.currentParentActiveRule;
    }

    boolean isCascading() {
        return this.cascading;
    }

    @CheckForNull
    QProfileDto getProfile() {
        return this.currentProfile;
    }

    Collection<QProfileDto> getChildProfiles() {
        if (this.currentProfile != null) {
            return this.profilesByParentUuid.get((Object)this.currentProfile.getKee());
        }
        Preconditions.checkState((boolean)this.currentRulesProfile.isBuiltIn());
        return this.builtInAliases.stream().flatMap(a -> this.profilesByParentUuid.get((Object)a.getKee()).stream()).collect(Collectors.toList());
    }

    public void reset(int ruleId) {
        this.cascading = false;
        this.doSwitch(this.baseProfile, this.baseRulesProfile, ruleId);
    }

    void switchToChild(QProfileDto to) {
        Preconditions.checkState((!to.isBuiltIn() ? 1 : 0) != 0);
        Objects.requireNonNull(this.currentRule, "can not switch profile if rule is not set");
        RuleDefinitionDto rule = this.currentRule.get();
        QProfileDto qp = Objects.requireNonNull(this.profilesByUuid.get(to.getKee()), () -> "No profile with uuid " + to.getKee());
        RulesProfileDto rulesProfile = RulesProfileDto.from((QProfileDto)qp);
        this.cascading = true;
        this.doSwitch(qp, rulesProfile, rule.getId());
    }

    private void doSwitch(@Nullable QProfileDto qp, RulesProfileDto rulesProfile, int ruleId) {
        String parentUuid;
        this.currentRule = this.rulesById.get(ruleId);
        WsUtils.checkRequest(this.currentRule != null, "Rule not found: %s", ruleId);
        RuleKey ruleKey = this.currentRule.get().getKey();
        WsUtils.checkRequest(rulesProfile.getLanguage().equals(this.currentRule.get().getLanguage()), "%s rule %s cannot be activated on %s profile %s", this.currentRule.get().getLanguage(), ruleKey, rulesProfile.getLanguage(), rulesProfile.getName());
        this.currentRulesProfile = rulesProfile;
        this.currentProfile = qp;
        this.currentActiveRule = this.activeRulesByKey.get(ActiveRuleKey.of((RulesProfileDto)rulesProfile, (RuleKey)ruleKey));
        this.currentParentActiveRule = null;
        if (this.currentProfile != null && (parentUuid = this.currentProfile.getParentKee()) != null) {
            QProfileDto parent = Objects.requireNonNull(this.profilesByUuid.get(parentUuid), () -> "No profile with uuid " + parentUuid);
            this.currentParentActiveRule = this.activeRulesByKey.get(ActiveRuleKey.of((QProfileDto)parent, (RuleKey)ruleKey));
        }
    }

    static final class ActiveRuleWrapper {
        private final ActiveRuleDto activeRule;
        private final Map<String, ActiveRuleParamDto> paramsByKey;

        private ActiveRuleWrapper(ActiveRuleDto activeRule, Collection<ActiveRuleParamDto> params) {
            this.activeRule = activeRule;
            this.paramsByKey = (Map)params.stream().collect(MoreCollectors.uniqueIndex(ActiveRuleParamDto::getKey));
        }

        ActiveRuleDto get() {
            return this.activeRule;
        }

        Collection<ActiveRuleParamDto> getParams() {
            return this.paramsByKey.values();
        }

        @CheckForNull
        ActiveRuleParamDto getParam(String key) {
            return this.paramsByKey.get(key);
        }

        @CheckForNull
        String getParamValue(String key) {
            ActiveRuleParamDto param = this.paramsByKey.get(key);
            return param != null ? param.getValue() : null;
        }
    }

    static final class RuleWrapper {
        private final RuleDefinitionDto rule;
        private final Map<String, RuleParamDto> paramsByKey;

        private RuleWrapper(RuleDefinitionDto rule, Collection<RuleParamDto> params) {
            this.rule = rule;
            this.paramsByKey = (Map)params.stream().collect(MoreCollectors.uniqueIndex(RuleParamDto::getName));
        }

        RuleDefinitionDto get() {
            return this.rule;
        }

        Collection<RuleParamDto> getParams() {
            return this.paramsByKey.values();
        }

        @CheckForNull
        RuleParamDto getParam(String key) {
            return this.paramsByKey.get(key);
        }

        @CheckForNull
        String getParamDefaultValue(String key) {
            RuleParamDto param = this.getParam(key);
            return param != null ? param.getDefaultValue() : null;
        }
    }

    static final class Builder {
        private long date = System.currentTimeMillis();
        private RulesProfileDto baseRulesProfile;
        private QProfileDto baseProfile;
        private Collection<RuleDefinitionDto> rules;
        private Collection<RuleParamDto> ruleParams;
        private Collection<QProfileDto> profiles;
        private Collection<ActiveRuleDto> activeRules;
        private Collection<ActiveRuleParamDto> activeRuleParams;

        Builder() {
        }

        Builder setDate(long l) {
            this.date = l;
            return this;
        }

        Builder setBaseProfile(RulesProfileDto p) {
            this.baseRulesProfile = p;
            this.baseProfile = null;
            return this;
        }

        Builder setBaseProfile(QProfileDto p) {
            this.baseRulesProfile = RulesProfileDto.from((QProfileDto)p);
            this.baseProfile = p;
            return this;
        }

        Builder setRules(Collection<RuleDefinitionDto> rules) {
            this.rules = rules;
            return this;
        }

        Builder setRuleParams(Collection<RuleParamDto> ruleParams) {
            this.ruleParams = ruleParams;
            return this;
        }

        Builder setProfiles(Collection<QProfileDto> profiles) {
            this.profiles = profiles;
            return this;
        }

        Builder setActiveRules(Collection<ActiveRuleDto> activeRules) {
            this.activeRules = activeRules;
            return this;
        }

        Builder setActiveRuleParams(Collection<ActiveRuleParamDto> activeRuleParams) {
            this.activeRuleParams = activeRuleParams;
            return this;
        }

        RuleActivationContext build() {
            Preconditions.checkArgument((this.date > 0L ? 1 : 0) != 0, (Object)"date is not set");
            Objects.requireNonNull(this.baseRulesProfile, "baseRulesProfile is null");
            Objects.requireNonNull(this.rules, "rules is null");
            Objects.requireNonNull(this.ruleParams, "ruleParams is null");
            Objects.requireNonNull(this.profiles, "profiles is null");
            Objects.requireNonNull(this.activeRules, "activeRules is null");
            Objects.requireNonNull(this.activeRuleParams, "activeRuleParams is null");
            return new RuleActivationContext(this);
        }
    }
}

