/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.qualityprofile;

import com.google.common.base.MoreObjects;
import java.util.Date;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class QualityProfile {
    private final String qpKey;
    private final String qpName;
    private final String languageKey;
    private final Date rulesUpdatedAt;

    public QualityProfile(String qpKey, String qpName, String languageKey, Date rulesUpdatedAt) {
        this.qpKey = Objects.requireNonNull(qpKey);
        this.qpName = Objects.requireNonNull(qpName);
        this.languageKey = Objects.requireNonNull(languageKey);
        this.rulesUpdatedAt = Objects.requireNonNull(rulesUpdatedAt);
    }

    public String getQpKey() {
        return this.qpKey;
    }

    public String getQpName() {
        return this.qpName;
    }

    public String getLanguageKey() {
        return this.languageKey;
    }

    public Date getRulesUpdatedAt() {
        return new Date(this.rulesUpdatedAt.getTime());
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QualityProfile qProfile = (QualityProfile)o;
        return this.qpKey.equals(qProfile.qpKey);
    }

    public int hashCode() {
        return this.qpKey.hashCode();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("key", (Object)this.qpKey).add("name", (Object)this.qpName).add("language", (Object)this.languageKey).add("rulesUpdatedAt", this.rulesUpdatedAt.getTime()).toString();
    }
}

