/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.qualityprofile;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Lists;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckForNull;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.profiles.ProfileExporter;
import org.sonar.api.profiles.ProfileImporter;
import org.sonar.api.profiles.RulesProfile;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.rules.ActiveRule;
import org.sonar.api.rules.ActiveRuleParam;
import org.sonar.api.rules.Rule;
import org.sonar.api.rules.RuleFinder;
import org.sonar.api.rules.RulePriority;
import org.sonar.api.server.ServerSide;
import org.sonar.api.utils.ValidationMessages;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.qualityprofile.ActiveRuleDto;
import org.sonar.db.qualityprofile.ActiveRuleParamDto;
import org.sonar.db.qualityprofile.QProfileDto;
import org.sonar.db.rule.RuleDefinitionDto;
import org.sonar.server.exceptions.BadRequestException;
import org.sonar.server.exceptions.NotFoundException;
import org.sonar.server.qualityprofile.ActiveRuleChange;
import org.sonar.server.qualityprofile.QProfileResult;
import org.sonar.server.qualityprofile.QProfileRules;
import org.sonar.server.qualityprofile.RuleActivation;
import org.sonar.server.ws.WsUtils;

@ServerSide
public class QProfileExporters {
    private final DbClient dbClient;
    private final RuleFinder ruleFinder;
    private final QProfileRules qProfileRules;
    private final ProfileExporter[] exporters;
    private final ProfileImporter[] importers;

    public QProfileExporters(DbClient dbClient, RuleFinder ruleFinder, QProfileRules qProfileRules, ProfileExporter[] exporters, ProfileImporter[] importers) {
        this.dbClient = dbClient;
        this.ruleFinder = ruleFinder;
        this.qProfileRules = qProfileRules;
        this.exporters = exporters;
        this.importers = importers;
    }

    public QProfileExporters(DbClient dbClient, RuleFinder ruleFinder, QProfileRules qProfileRules, ProfileExporter[] exporters) {
        this(dbClient, ruleFinder, qProfileRules, exporters, new ProfileImporter[0]);
    }

    public QProfileExporters(DbClient dbClient, RuleFinder ruleFinder, QProfileRules qProfileRules, ProfileImporter[] importers) {
        this(dbClient, ruleFinder, qProfileRules, new ProfileExporter[0], importers);
    }

    public QProfileExporters(DbClient dbClient, RuleFinder ruleFinder, QProfileRules qProfileRules) {
        this(dbClient, ruleFinder, qProfileRules, new ProfileExporter[0], new ProfileImporter[0]);
    }

    public List<ProfileExporter> exportersForLanguage(String language) {
        ArrayList<ProfileExporter> result = new ArrayList<ProfileExporter>();
        for (ProfileExporter exporter : this.exporters) {
            if (exporter.getSupportedLanguages() != null && exporter.getSupportedLanguages().length != 0 && !ArrayUtils.contains((Object[])exporter.getSupportedLanguages(), (Object)language)) continue;
            result.add(exporter);
        }
        return result;
    }

    public String mimeType(String exporterKey) {
        ProfileExporter exporter = this.findExporter(exporterKey);
        return exporter.getMimeType();
    }

    public void export(DbSession dbSession, QProfileDto profile, String exporterKey, Writer writer) {
        ProfileExporter exporter = this.findExporter(exporterKey);
        exporter.exportProfile(this.wrap(dbSession, profile), writer);
    }

    private RulesProfile wrap(DbSession dbSession, QProfileDto profile) {
        RulesProfile target = new RulesProfile(profile.getName(), profile.getLanguage());
        List activeRuleDtos = this.dbClient.activeRuleDao().selectByProfile(dbSession, profile);
        List activeRuleParamDtos = this.dbClient.activeRuleDao().selectParamsByActiveRuleIds(dbSession, Lists.transform((List)activeRuleDtos, ActiveRuleDto::getId));
        ImmutableListMultimap activeRuleParamsByActiveRuleId = FluentIterable.from((Iterable)activeRuleParamDtos).index(ActiveRuleParamDto::getActiveRuleId);
        for (ActiveRuleDto activeRule : activeRuleDtos) {
            Rule rule = this.ruleFinder.findByKey(activeRule.getRuleKey());
            ActiveRule wrappedActiveRule = target.activateRule(rule, RulePriority.valueOf((String)activeRule.getSeverityString()));
            List paramDtos = activeRuleParamsByActiveRuleId.get((Object)activeRule.getId());
            for (ActiveRuleParamDto activeRuleParamDto : paramDtos) {
                wrappedActiveRule.setParameter(activeRuleParamDto.getKey(), activeRuleParamDto.getValue());
            }
        }
        return target;
    }

    private ProfileExporter findExporter(String exporterKey) {
        for (ProfileExporter e : this.exporters) {
            if (!exporterKey.equals(e.getKey())) continue;
            return e;
        }
        throw new NotFoundException("Unknown quality profile exporter: " + exporterKey);
    }

    public QProfileResult importXml(QProfileDto profile, String importerKey, InputStream xml, DbSession dbSession) {
        return this.importXml(profile, importerKey, new InputStreamReader(xml, StandardCharsets.UTF_8), dbSession);
    }

    private QProfileResult importXml(QProfileDto profile, String importerKey, Reader xml, DbSession dbSession) {
        QProfileResult result = new QProfileResult();
        ValidationMessages messages = ValidationMessages.create();
        ProfileImporter importer = this.getProfileImporter(importerKey);
        RulesProfile definition = importer.importProfile(xml, messages);
        List<ActiveRuleChange> changes = this.importProfile(profile, definition, dbSession);
        result.addChanges(changes);
        QProfileExporters.processValidationMessages(messages, result);
        return result;
    }

    private List<ActiveRuleChange> importProfile(QProfileDto profile, RulesProfile definition, DbSession dbSession) {
        Map rulesByRuleKey = (Map)this.dbClient.ruleDao().selectAllDefinitions(dbSession).stream().collect(MoreCollectors.uniqueIndex(RuleDefinitionDto::getKey));
        List activeRules = definition.getActiveRules();
        List activations = (List)activeRules.stream().map(activeRule -> QProfileExporters.toRuleActivation(activeRule, rulesByRuleKey)).filter(Objects::nonNull).collect(MoreCollectors.toArrayList((int)activeRules.size()));
        return this.qProfileRules.activateAndCommit(dbSession, profile, activations);
    }

    private ProfileImporter getProfileImporter(String importerKey) {
        for (ProfileImporter importer : this.importers) {
            if (!StringUtils.equals((String)importerKey, (String)importer.getKey())) continue;
            return importer;
        }
        throw BadRequestException.create("No such importer : " + importerKey);
    }

    private static void processValidationMessages(ValidationMessages messages, QProfileResult result) {
        WsUtils.checkRequest(messages.getErrors().isEmpty(), messages.getErrors());
        result.addWarnings(messages.getWarnings());
        result.addInfos(messages.getInfos());
    }

    @CheckForNull
    private static RuleActivation toRuleActivation(ActiveRule activeRule, Map<RuleKey, RuleDefinitionDto> rulesByRuleKey) {
        RuleKey ruleKey = activeRule.getRule().ruleKey();
        RuleDefinitionDto ruleDefinition = rulesByRuleKey.get(ruleKey);
        if (ruleDefinition == null) {
            return null;
        }
        String severity = activeRule.getSeverity().name();
        Map params = (Map)activeRule.getActiveRuleParams().stream().collect(MoreCollectors.uniqueIndex(ActiveRuleParam::getKey, ActiveRuleParam::getValue));
        return RuleActivation.create(ruleDefinition.getId(), severity, params);
    }
}

