/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.qualitygate.ws;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.protobuf.Message;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.core.util.Protobuf;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.qualitygate.QGateWithOrgDto;
import org.sonar.db.qualitygate.QualityGateConditionDto;
import org.sonar.server.qualitygate.QualityGateConditionsUpdater;
import org.sonar.server.qualitygate.ws.QualityGatesWs;
import org.sonar.server.qualitygate.ws.QualityGatesWsAction;
import org.sonar.server.qualitygate.ws.QualityGatesWsSupport;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.Qualitygates;

public class UpdateConditionAction
implements QualityGatesWsAction {
    private final DbClient dbClient;
    private final QualityGateConditionsUpdater qualityGateConditionsUpdater;
    private final QualityGatesWsSupport wsSupport;

    public UpdateConditionAction(DbClient dbClient, QualityGateConditionsUpdater qualityGateConditionsUpdater, QualityGatesWsSupport wsSupport) {
        this.dbClient = dbClient;
        this.qualityGateConditionsUpdater = qualityGateConditionsUpdater;
        this.wsSupport = wsSupport;
    }

    public void define(WebService.NewController controller) {
        WebService.NewAction createCondition = controller.createAction("update_condition").setDescription("Update a condition attached to a quality gate.<br>Requires the 'Administer Quality Gates' permission.").setPost(true).setSince("4.3").setHandler((RequestHandler)this);
        createCondition.createParam("id").setDescription("Condition ID").setRequired(true).setExampleValue((Object)"10");
        QualityGatesWs.addConditionParams(createCondition);
        this.wsSupport.createOrganizationParam(createCondition);
    }

    public void handle(Request request, Response response) {
        int id = request.mandatoryParamAsInt("id");
        String metric = request.mandatoryParam("metric");
        String operator = request.mandatoryParam("op");
        String warning = request.param("warning");
        String error = request.param("error");
        Integer period = request.paramAsInt("period");
        try (DbSession dbSession = this.dbClient.openSession(false);){
            OrganizationDto organization = this.wsSupport.getOrganization(dbSession, request);
            QualityGateConditionDto condition = this.wsSupport.getCondition(dbSession, id);
            QGateWithOrgDto qualityGateDto = this.dbClient.qualityGateDao().selectByOrganizationAndId(dbSession, organization, condition.getQualityGateId());
            Preconditions.checkState((qualityGateDto != null ? 1 : 0) != 0, (String)"Condition '%s' is linked to an unknown quality gate '%s'", (Object[])new Object[]{id, condition.getQualityGateId()});
            this.wsSupport.checkCanEdit(qualityGateDto);
            QualityGateConditionDto updatedCondition = this.qualityGateConditionsUpdater.updateCondition(dbSession, condition, metric, operator, Strings.emptyToNull((String)warning), Strings.emptyToNull((String)error), period);
            Qualitygates.UpdateConditionResponse.Builder updateConditionResponse = Qualitygates.UpdateConditionResponse.newBuilder().setId(updatedCondition.getId()).setMetric(updatedCondition.getMetricKey()).setOp(updatedCondition.getOperator());
            Protobuf.setNullable((Object)updatedCondition.getWarningThreshold(), arg_0 -> ((Qualitygates.UpdateConditionResponse.Builder)updateConditionResponse).setWarning(arg_0));
            Protobuf.setNullable((Object)updatedCondition.getErrorThreshold(), arg_0 -> ((Qualitygates.UpdateConditionResponse.Builder)updateConditionResponse).setError(arg_0));
            Protobuf.setNullable((Object)updatedCondition.getPeriod(), arg_0 -> ((Qualitygates.UpdateConditionResponse.Builder)updateConditionResponse).setPeriod(arg_0));
            WsUtils.writeProtobuf((Message)updateConditionResponse.build(), request, response);
            dbSession.commit();
        }
    }
}

