/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.qualitygate.ws;

import com.google.common.base.Preconditions;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.qualitygate.QGateWithOrgDto;
import org.sonar.db.qualitygate.QualityGateDto;
import org.sonar.server.qualitygate.QualityGateFinder;
import org.sonar.server.qualitygate.ws.QualityGatesWsAction;
import org.sonar.server.qualitygate.ws.QualityGatesWsSupport;

public class DestroyAction
implements QualityGatesWsAction {
    private final DbClient dbClient;
    private final QualityGatesWsSupport wsSupport;
    private final QualityGateFinder finder;

    public DestroyAction(DbClient dbClient, QualityGatesWsSupport wsSupport, QualityGateFinder finder) {
        this.dbClient = dbClient;
        this.wsSupport = wsSupport;
        this.finder = finder;
    }

    public void define(WebService.NewController controller) {
        WebService.NewAction action = controller.createAction("destroy").setDescription("Delete a Quality Gate.<br>Requires the 'Administer Quality Gates' permission.").setSince("4.3").setPost(true).setHandler((RequestHandler)this);
        action.createParam("id").setDescription("ID of the quality gate to delete").setRequired(true).setExampleValue((Object)"1");
        this.wsSupport.createOrganizationParam(action);
    }

    public void handle(Request request, Response response) {
        long qualityGateId = request.mandatoryParamAsLong("id");
        try (DbSession dbSession = this.dbClient.openSession(false);){
            OrganizationDto organization = this.wsSupport.getOrganization(dbSession, request);
            QGateWithOrgDto qualityGate = this.finder.getByOrganizationAndId(dbSession, organization, qualityGateId);
            QualityGateDto defaultQualityGate = this.finder.getDefault(dbSession, organization);
            Preconditions.checkArgument((!defaultQualityGate.getId().equals(qualityGate.getId()) ? 1 : 0) != 0, (Object)"The default quality gate cannot be removed");
            this.wsSupport.checkCanEdit(qualityGate);
            this.dbClient.propertiesDao().deleteByKeyAndValue(dbSession, "sonar.qualitygate", String.valueOf(qualityGate.getId()));
            this.dbClient.qualityGateDao().delete((QualityGateDto)qualityGate, dbSession);
            dbSession.commit();
            response.noContent();
        }
    }
}

