/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.qualitygate.ws;

import com.google.common.base.Preconditions;
import com.google.protobuf.Message;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.permission.OrganizationPermission;
import org.sonar.db.qualitygate.QGateWithOrgDto;
import org.sonar.db.qualitygate.QualityGateDto;
import org.sonar.server.qualitygate.QualityGateFinder;
import org.sonar.server.qualitygate.QualityGateUpdater;
import org.sonar.server.qualitygate.ws.QualityGatesWs;
import org.sonar.server.qualitygate.ws.QualityGatesWsAction;
import org.sonar.server.qualitygate.ws.QualityGatesWsSupport;
import org.sonar.server.user.UserSession;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.Qualitygates;

public class CopyAction
implements QualityGatesWsAction {
    private final DbClient dbClient;
    private final UserSession userSession;
    private final QualityGateUpdater qualityGateUpdater;
    private final QualityGateFinder qualityGateFinder;
    private final QualityGatesWsSupport wsSupport;

    public CopyAction(DbClient dbClient, UserSession userSession, QualityGateUpdater qualityGateUpdater, QualityGateFinder qualityGateFinder, QualityGatesWsSupport wsSupport) {
        this.dbClient = dbClient;
        this.userSession = userSession;
        this.qualityGateUpdater = qualityGateUpdater;
        this.qualityGateFinder = qualityGateFinder;
        this.wsSupport = wsSupport;
    }

    public void define(WebService.NewController controller) {
        WebService.NewAction action = controller.createAction("copy").setDescription("Copy a Quality Gate.<br>Requires the 'Administer Quality Gates' permission.").setPost(true).setSince("4.3").setHandler((RequestHandler)this);
        action.createParam("id").setDescription("The ID of the source quality gate").setRequired(true).setExampleValue((Object)"1");
        action.createParam("name").setDescription("The name of the quality gate to create").setRequired(true).setExampleValue((Object)"My Quality Gate");
        this.wsSupport.createOrganizationParam(action);
    }

    public void handle(Request request, Response response) {
        Long id = QualityGatesWs.parseId(request, "id");
        String destinationName = request.mandatoryParam("name");
        Preconditions.checkArgument((!destinationName.isEmpty() ? 1 : 0) != 0, (Object)"The 'name' parameter is empty");
        try (DbSession dbSession = this.dbClient.openSession(false);){
            OrganizationDto organization = this.wsSupport.getOrganization(dbSession, request);
            this.userSession.checkPermission(OrganizationPermission.ADMINISTER_QUALITY_GATES, organization);
            QGateWithOrgDto qualityGate = this.qualityGateFinder.getByOrganizationAndId(dbSession, organization, id);
            QualityGateDto copy = this.qualityGateUpdater.copy(dbSession, organization, (QualityGateDto)qualityGate, destinationName);
            dbSession.commit();
            WsUtils.writeProtobuf((Message)Qualitygates.QualityGate.newBuilder().setId(copy.getId().longValue()).setName(copy.getName()).build(), request, response);
        }
    }
}

