/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.qualitygate;

import com.google.common.base.Preconditions;
import org.sonar.core.util.UuidFactory;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.property.PropertyDto;
import org.sonar.db.qualitygate.QGateWithOrgDto;
import org.sonar.db.qualitygate.QualityGateConditionDto;
import org.sonar.db.qualitygate.QualityGateDto;

public class QualityGateUpdater {
    private final DbClient dbClient;
    private final UuidFactory uuidFactory;

    public QualityGateUpdater(DbClient dbClient, UuidFactory uuidFactory) {
        this.dbClient = dbClient;
        this.uuidFactory = uuidFactory;
    }

    public QualityGateDto create(DbSession dbSession, OrganizationDto organizationDto, String name) {
        this.validateQualityGate(dbSession, organizationDto, name);
        QualityGateDto newQualityGate = new QualityGateDto().setName(name).setBuiltIn(false).setUuid(this.uuidFactory.create());
        this.dbClient.qualityGateDao().insert(dbSession, newQualityGate);
        this.dbClient.qualityGateDao().associate(dbSession, this.uuidFactory.create(), organizationDto, newQualityGate);
        return newQualityGate;
    }

    public QualityGateDto copy(DbSession dbSession, OrganizationDto organizationDto, QualityGateDto qualityGateDto, String destinationName) {
        QualityGateDto destinationGate = this.create(dbSession, organizationDto, destinationName);
        for (QualityGateConditionDto sourceCondition : this.dbClient.gateConditionDao().selectForQualityGate(dbSession, qualityGateDto.getId().longValue())) {
            this.dbClient.gateConditionDao().insert(new QualityGateConditionDto().setQualityGateId(destinationGate.getId().longValue()).setMetricId(sourceCondition.getMetricId()).setOperator(sourceCondition.getOperator()).setWarningThreshold(sourceCondition.getWarningThreshold()).setErrorThreshold(sourceCondition.getErrorThreshold()).setPeriod(sourceCondition.getPeriod()), dbSession);
        }
        return destinationGate;
    }

    private void validateQualityGate(DbSession dbSession, OrganizationDto organizationDto, String name) {
        this.checkQualityGateDoesNotAlreadyExist(dbSession, organizationDto, name);
    }

    public void setDefault(DbSession dbSession, OrganizationDto organizationDto, QualityGateDto qualityGateDto) {
        organizationDto.setDefaultQualityGateUuid(qualityGateDto.getUuid());
        this.dbClient.qualityGateDao().update(qualityGateDto, dbSession);
    }

    public void dissociateProject(DbSession dbSession, ComponentDto project) {
        this.dbClient.propertiesDao().deleteProjectProperty("sonar.qualitygate", project.getId(), dbSession);
    }

    public void associateProject(DbSession dbSession, ComponentDto project, QualityGateDto qualityGate) {
        this.dbClient.propertiesDao().saveProperty(dbSession, new PropertyDto().setKey("sonar.qualitygate").setResourceId(project.getId()).setValue(String.valueOf(qualityGate.getId())));
    }

    private void checkQualityGateDoesNotAlreadyExist(DbSession dbSession, OrganizationDto organizationDto, String name) {
        QGateWithOrgDto existingQgate = this.dbClient.qualityGateDao().selectByOrganizationAndName(dbSession, organizationDto, name);
        Preconditions.checkArgument((existingQgate == null ? 1 : 0) != 0, (String)"%s has already been taken", (Object[])new Object[]{"Name"});
    }
}

