/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.qualitygate;

import com.google.common.base.Preconditions;
import java.util.Optional;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.qualitygate.QGateWithOrgDto;
import org.sonar.db.qualitygate.QualityGateDto;
import org.sonar.server.ws.WsUtils;

public class QualityGateFinder {
    public static final String SONAR_QUALITYGATE_PROPERTY = "sonar.qualitygate";
    private final DbClient dbClient;

    public QualityGateFinder(DbClient dbClient) {
        this.dbClient = dbClient;
    }

    public QualityGateData getQualityGate(DbSession dbSession, OrganizationDto organization, ComponentDto component) {
        Optional qualityGateId = this.dbClient.projectQgateAssociationDao().selectQGateIdByComponentId(dbSession, component.getId().longValue());
        if (qualityGateId.isPresent()) {
            QualityGateDto qualityGate = WsUtils.checkFound(this.dbClient.qualityGateDao().selectById(dbSession, ((Long)qualityGateId.get()).longValue()), "No quality gate has been found for id %s", qualityGateId);
            return new QualityGateData(qualityGate, false);
        }
        QGateWithOrgDto defaultQualityGate = this.dbClient.qualityGateDao().selectByOrganizationAndUuid(dbSession, organization, organization.getDefaultQualityGateUuid());
        Preconditions.checkState((defaultQualityGate != null ? 1 : 0) != 0, (String)"Unable to find the quality gate [%s] for organization [%s]", (Object[])new Object[]{organization.getDefaultQualityGateUuid(), organization.getUuid()});
        return new QualityGateData((QualityGateDto)defaultQualityGate, true);
    }

    public QGateWithOrgDto getByOrganizationAndId(DbSession dbSession, OrganizationDto organization, long qualityGateId) {
        return WsUtils.checkFound(this.dbClient.qualityGateDao().selectByOrganizationAndId(dbSession, organization, qualityGateId), "No quality gate has been found for id %s in organization %s", qualityGateId, organization.getName());
    }

    public QualityGateDto getDefault(DbSession dbSession, OrganizationDto organization) {
        QGateWithOrgDto qgate = this.dbClient.qualityGateDao().selectByOrganizationAndUuid(dbSession, organization, organization.getDefaultQualityGateUuid());
        Preconditions.checkState((qgate != null ? 1 : 0) != 0, (String)"Default quality gate [%s] is missing on organization [%s]", (Object[])new Object[]{organization.getDefaultQualityGateUuid(), organization.getUuid()});
        return qgate;
    }

    public QualityGateDto getBuiltInQualityGate(DbSession dbSession) {
        QualityGateDto builtIn = this.dbClient.qualityGateDao().selectBuiltIn(dbSession);
        Preconditions.checkState((builtIn != null ? 1 : 0) != 0, (Object)"Builtin quality gate is missing.");
        return builtIn;
    }

    public static class QualityGateData {
        private final QualityGateDto qualityGate;
        private final boolean isDefault;

        private QualityGateData(QualityGateDto qualityGate, boolean isDefault) {
            this.qualityGate = qualityGate;
            this.isDefault = isDefault;
        }

        public QualityGateDto getQualityGate() {
            return this.qualityGate;
        }

        public boolean isDefault() {
            return this.isDefault;
        }
    }
}

