/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.qualitygate;

import java.util.EnumSet;
import java.util.Optional;
import java.util.Set;
import javax.annotation.CheckForNull;
import org.sonar.api.measures.Metric;
import org.sonar.server.qualitygate.Condition;
import org.sonar.server.qualitygate.EvaluatedCondition;
import org.sonar.server.qualitygate.QualityGateEvaluator;

class ConditionEvaluator {
    private static final Set<Metric.ValueType> NUMERICAL_TYPES = EnumSet.of(Metric.ValueType.BOOL, new Metric.ValueType[]{Metric.ValueType.INT, Metric.ValueType.RATING, Metric.ValueType.FLOAT, Metric.ValueType.MILLISEC, Metric.ValueType.PERCENT, Metric.ValueType.WORK_DUR});

    private ConditionEvaluator() {
    }

    static EvaluatedCondition evaluate(Condition condition, QualityGateEvaluator.Measures measures) {
        Optional<QualityGateEvaluator.Measure> measure = measures.get(condition.getMetricKey());
        if (!measure.isPresent()) {
            return new EvaluatedCondition(condition, EvaluatedCondition.EvaluationStatus.OK, null);
        }
        Optional<Comparable> value = ConditionEvaluator.getMeasureValue(condition, measure.get());
        if (!value.isPresent()) {
            return new EvaluatedCondition(condition, EvaluatedCondition.EvaluationStatus.OK, null);
        }
        Metric.ValueType type = measure.get().getType();
        return ConditionEvaluator.evaluateCondition(condition, type, value.get(), true).orElseGet(() -> ConditionEvaluator.evaluateCondition(condition, type, (Comparable)value.get(), false).orElseGet(() -> new EvaluatedCondition(condition, EvaluatedCondition.EvaluationStatus.OK, ((Comparable)value.get()).toString())));
    }

    private static Optional<EvaluatedCondition> evaluateCondition(Condition condition, Metric.ValueType type, Comparable value, boolean error) {
        Optional<Comparable> threshold = ConditionEvaluator.getThreshold(condition, type, error);
        if (!threshold.isPresent()) {
            return Optional.empty();
        }
        if (ConditionEvaluator.reachThreshold(value, threshold.get(), condition)) {
            EvaluatedCondition.EvaluationStatus status = error ? EvaluatedCondition.EvaluationStatus.ERROR : EvaluatedCondition.EvaluationStatus.WARN;
            return Optional.of(new EvaluatedCondition(condition, status, value.toString()));
        }
        return Optional.empty();
    }

    private static Optional<Comparable> getThreshold(Condition condition, Metric.ValueType valueType, boolean error) {
        Optional<String> valString = error ? condition.getErrorThreshold() : condition.getWarningThreshold();
        return valString.map(s -> {
            try {
                switch (valueType) {
                    case BOOL: {
                        return Boolean.valueOf(ConditionEvaluator.parseInteger(s) == 1);
                    }
                    case INT: 
                    case RATING: {
                        return Integer.valueOf(ConditionEvaluator.parseInteger(s));
                    }
                    case MILLISEC: 
                    case WORK_DUR: {
                        return Long.valueOf(Long.parseLong(s));
                    }
                    case FLOAT: 
                    case PERCENT: {
                        return Double.valueOf(Double.parseDouble(s));
                    }
                    case LEVEL: 
                    case STRING: {
                        return s;
                    }
                }
                throw new IllegalArgumentException(String.format("Unsupported value type %s. Cannot convert condition value", valueType));
            }
            catch (NumberFormatException badValueFormat) {
                throw new IllegalArgumentException(String.format("Quality Gate: unable to parse threshold '%s' to compare against %s", s, condition.getMetricKey()));
            }
        });
    }

    private static Optional<Comparable> getMeasureValue(Condition condition, QualityGateEvaluator.Measure measure) {
        if (condition.isOnLeakPeriod()) {
            return Optional.ofNullable(ConditionEvaluator.getLeakValue(measure));
        }
        return Optional.ofNullable(ConditionEvaluator.getValue(measure));
    }

    @CheckForNull
    private static Comparable getValue(QualityGateEvaluator.Measure measure) {
        if (NUMERICAL_TYPES.contains(measure.getType())) {
            return measure.getValue().isPresent() ? ConditionEvaluator.getNumericValue(measure.getType(), measure.getValue().getAsDouble()) : null;
        }
        switch (measure.getType()) {
            case LEVEL: 
            case STRING: 
            case DISTRIB: {
                return measure.getStringValue().orElse(null);
            }
        }
        throw new IllegalArgumentException("Condition on leak period is not allowed for type " + measure.getType());
    }

    @CheckForNull
    private static Comparable getLeakValue(QualityGateEvaluator.Measure measure) {
        if (NUMERICAL_TYPES.contains(measure.getType())) {
            return measure.getLeakValue().isPresent() ? ConditionEvaluator.getNumericValue(measure.getType(), measure.getLeakValue().getAsDouble()) : null;
        }
        throw new IllegalArgumentException("Condition on leak period is not allowed for type " + measure.getType());
    }

    private static Comparable getNumericValue(Metric.ValueType type, double value) {
        switch (type) {
            case BOOL: {
                return Boolean.valueOf(Double.compare(value, 1.0) == 1);
            }
            case INT: 
            case RATING: {
                return Integer.valueOf((int)value);
            }
            case FLOAT: 
            case PERCENT: {
                return Double.valueOf(value);
            }
            case MILLISEC: 
            case WORK_DUR: {
                return Long.valueOf((long)value);
            }
        }
        throw new IllegalArgumentException("Condition on numeric value is not allowed for type " + type);
    }

    private static int parseInteger(String value) {
        return value.contains(".") ? Integer.parseInt(value.substring(0, value.indexOf(46))) : Integer.parseInt(value);
    }

    private static boolean reachThreshold(Comparable measureValue, Comparable threshold, Condition condition) {
        int comparison = measureValue.compareTo(threshold);
        switch (condition.getOperator()) {
            case EQUALS: {
                return comparison == 0;
            }
            case NOT_EQUALS: {
                return comparison != 0;
            }
            case GREATER_THAN: {
                return comparison > 0;
            }
            case LESS_THAN: {
                return comparison < 0;
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported operator '%s'", new Object[]{condition.getOperator()}));
    }
}

