/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.projectanalysis.ws;

import com.google.common.base.Preconditions;
import com.google.protobuf.Message;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.core.util.Protobuf;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.SnapshotDto;
import org.sonar.db.event.EventDto;
import org.sonar.server.exceptions.NotFoundException;
import org.sonar.server.projectanalysis.ws.EventCategory;
import org.sonar.server.projectanalysis.ws.EventValidator;
import org.sonar.server.projectanalysis.ws.ProjectAnalysesWsAction;
import org.sonar.server.user.UserSession;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.ProjectAnalyses;

public class UpdateEventAction
implements ProjectAnalysesWsAction {
    private static final int MAX_NAME_LENGTH = 100;
    private final DbClient dbClient;
    private final UserSession userSession;

    public UpdateEventAction(DbClient dbClient, UserSession userSession) {
        this.dbClient = dbClient;
        this.userSession = userSession;
    }

    public void define(WebService.NewController context) {
        WebService.NewAction action = context.createAction("update_event").setDescription("Update a project analysis event.<br>Only events of category '%s' and '%s' can be updated.<br>Requires one of the following permissions:<ul>  <li>'Administer System'</li>  <li>'Administer' rights on the specified project</li></ul>", new Object[]{EventCategory.VERSION.name(), EventCategory.OTHER.name()}).setSince("6.3").setPost(true).setResponseExample(this.getClass().getResource("update_event-example.json")).setHandler((RequestHandler)this);
        action.createParam("event").setDescription("Event key").setExampleValue((Object)"AU-TpxcA-iU5OvuD2FL5").setRequired(true);
        action.createParam("name").setMaximumLength(Integer.valueOf(400)).setDescription("New name").setExampleValue((Object)"5.6").setRequired(true);
    }

    public void handle(Request httpRequest, Response httpResponse) throws Exception {
        Stream.of(httpRequest).map(UpdateEventAction.toUpdateEventRequest()).map(this::doHandle).forEach(wsResponse -> WsUtils.writeProtobuf((Message)wsResponse, httpRequest, httpResponse));
    }

    private ProjectAnalyses.UpdateEventResponse doHandle(UpdateEventRequest request) {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            ProjectAnalyses.UpdateEventResponse updateEventResponse = Stream.of(this.getDbEvent(dbSession, request)).peek(this.checkPermissions()).peek(EventValidator.checkModifiable()).peek(UpdateEventAction.checkVersionNameLength(request)).map(UpdateEventAction.updateNameAndDescription(request)).peek(this.checkNonConflictingOtherEvents(dbSession)).peek(this.updateInDb(dbSession)).map(UpdateEventAction.toWsResponse()).findAny().orElseThrow(() -> new IllegalStateException("Event not found"));
            return updateEventResponse;
        }
    }

    private Consumer<EventDto> updateInDb(DbSession dbSession) {
        return event -> {
            this.dbClient.eventDao().update(dbSession, event.getUuid(), event.getName(), event.getDescription());
            if (EventCategory.VERSION.getLabel().equals(event.getCategory())) {
                SnapshotDto analysis = this.getAnalysis(dbSession, (EventDto)event);
                analysis.setVersion(event.getName());
                this.dbClient.snapshotDao().update(dbSession, analysis);
            }
            dbSession.commit();
        };
    }

    private EventDto getDbEvent(DbSession dbSession, UpdateEventRequest request) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)request.getName()), (Object)"A non empty name is required");
        return (EventDto)this.dbClient.eventDao().selectByUuid(dbSession, request.getEvent()).orElseThrow(() -> new NotFoundException(String.format("Event '%s' not found", request.getEvent())));
    }

    private Consumer<EventDto> checkPermissions() {
        return event -> this.userSession.checkComponentUuidPermission("admin", event.getComponentUuid());
    }

    private Consumer<EventDto> checkNonConflictingOtherEvents(DbSession dbSession) {
        return candidateEvent -> {
            List dbEvents = this.dbClient.eventDao().selectByAnalysisUuid(dbSession, candidateEvent.getAnalysisUuid());
            Predicate<EventDto> otherEventWithSameName = otherEvent -> !candidateEvent.getUuid().equals(otherEvent.getUuid()) && otherEvent.getName().equals(candidateEvent.getName());
            dbEvents.stream().filter(otherEventWithSameName).findAny().ifPresent(event -> {
                throw new IllegalArgumentException(String.format("An '%s' event with the same name already exists on analysis '%s'", candidateEvent.getCategory(), candidateEvent.getAnalysisUuid()));
            });
        };
    }

    private static Consumer<EventDto> checkVersionNameLength(UpdateEventRequest request) {
        String name = request.getName();
        return candidateEvent -> {
            if (name != null && EventCategory.VERSION.getLabel().equals(candidateEvent.getCategory())) {
                Preconditions.checkArgument((name.length() <= 100 ? 1 : 0) != 0, (String)"Version length (%s) is longer than the maximum authorized (%s). '%s' was provided.", (Object[])new Object[]{name.length(), 100, name});
            }
        };
    }

    private SnapshotDto getAnalysis(DbSession dbSession, EventDto event) {
        return (SnapshotDto)this.dbClient.snapshotDao().selectByUuid(dbSession, event.getAnalysisUuid()).orElseThrow(() -> new IllegalStateException(String.format("Analysis '%s' is not found", event.getAnalysisUuid())));
    }

    private static Function<EventDto, EventDto> updateNameAndDescription(UpdateEventRequest request) {
        return event -> {
            Protobuf.setNullable((Object)request.getName(), arg_0 -> ((EventDto)event).setName(arg_0));
            return event;
        };
    }

    private static Function<EventDto, ProjectAnalyses.UpdateEventResponse> toWsResponse() {
        return dbEvent -> {
            ProjectAnalyses.Event.Builder wsEvent = ProjectAnalyses.Event.newBuilder().setKey(dbEvent.getUuid()).setCategory(EventCategory.fromLabel(dbEvent.getCategory()).name()).setAnalysis(dbEvent.getAnalysisUuid());
            Protobuf.setNullable((Object)dbEvent.getName(), arg_0 -> ((ProjectAnalyses.Event.Builder)wsEvent).setName(arg_0));
            Protobuf.setNullable((Object)dbEvent.getDescription(), arg_0 -> ((ProjectAnalyses.Event.Builder)wsEvent).setDescription(arg_0));
            return ProjectAnalyses.UpdateEventResponse.newBuilder().setEvent(wsEvent).build();
        };
    }

    private static Function<Request, UpdateEventRequest> toUpdateEventRequest() {
        return request -> new UpdateEventRequest(request.mandatoryParam("event"), request.param("name"));
    }

    private static class UpdateEventRequest {
        private final String event;
        private final String name;

        public UpdateEventRequest(String event, String name) {
            this.event = Objects.requireNonNull(event, "Event key is required");
            this.name = Objects.requireNonNull(name, "Name is required");
        }

        public String getEvent() {
            return this.event;
        }

        @CheckForNull
        public String getName() {
            return this.name;
        }
    }
}

