/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.plugins.ws;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Ordering;
import com.google.common.io.Resources;
import java.util.Collection;
import java.util.List;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.utils.text.JsonWriter;
import org.sonar.server.plugins.UpdateCenterMatrixFactory;
import org.sonar.server.plugins.ws.PluginUpdateAggregator;
import org.sonar.server.plugins.ws.PluginWSCommons;
import org.sonar.server.plugins.ws.PluginsWsAction;
import org.sonar.server.user.UserSession;
import org.sonar.updatecenter.common.Plugin;
import org.sonar.updatecenter.common.PluginUpdate;
import org.sonar.updatecenter.common.UpdateCenter;

public class UpdatesAction
implements PluginsWsAction {
    private static final boolean DO_NOT_FORCE_REFRESH = false;
    private static final String ARRAY_PLUGINS = "plugins";
    private static final String ARRAY_UPDATES = "updates";
    private static final Ordering<PluginUpdateAggregator.PluginUpdateAggregate> NAME_KEY_PLUGIN_UPGRADE_AGGREGATE_ORDERING = Ordering.from(PluginWSCommons.NAME_KEY_PLUGIN_ORDERING).onResultOf(PluginUpdateAggregator.PluginUpdateAggregate::getPlugin);
    private static final Ordering<PluginUpdate> PLUGIN_UPDATE_BY_VERSION_ORDERING = Ordering.natural().onResultOf(input -> input.getRelease().getVersion().toString());
    private final UserSession userSession;
    private final UpdateCenterMatrixFactory updateCenterMatrixFactory;
    private final PluginUpdateAggregator aggregator;

    public UpdatesAction(UserSession userSession, UpdateCenterMatrixFactory updateCenterMatrixFactory, PluginUpdateAggregator aggregator) {
        this.userSession = userSession;
        this.updateCenterMatrixFactory = updateCenterMatrixFactory;
        this.aggregator = aggregator;
    }

    public void define(WebService.NewController controller) {
        controller.createAction(ARRAY_UPDATES).setDescription("Lists plugins installed on the SonarQube instance for which at least one newer version is available, sorted by plugin name.<br/>Each newer version is listed, ordered from the oldest to the newest, with its own update/compatibility status.<br/>Plugin information is retrieved from Update Center. Date and time at which Update Center was last refreshed is provided in the response.<br/>Update status values are: [COMPATIBLE, INCOMPATIBLE, REQUIRES_UPGRADE, DEPS_REQUIRE_UPGRADE].<br/>Require 'Administer System' permission.").setSince("5.2").setHandler((RequestHandler)this).setResponseExample(Resources.getResource(this.getClass(), (String)"example-updates_plugins.json"));
    }

    public void handle(Request request, Response response) throws Exception {
        this.userSession.checkIsSystemAdministrator();
        JsonWriter jsonWriter = response.newJsonWriter();
        jsonWriter.beginObject();
        Optional<UpdateCenter> updateCenter = this.updateCenterMatrixFactory.getUpdateCenter(false);
        this.writePlugins(jsonWriter, updateCenter);
        PluginWSCommons.writeUpdateCenterProperties(jsonWriter, updateCenter);
        jsonWriter.endObject();
        jsonWriter.close();
    }

    private void writePlugins(JsonWriter jsonWriter, Optional<UpdateCenter> updateCenter) {
        jsonWriter.name(ARRAY_PLUGINS);
        jsonWriter.beginArray();
        if (updateCenter.isPresent()) {
            for (PluginUpdateAggregator.PluginUpdateAggregate aggregate : this.retrieveUpdatablePlugins((UpdateCenter)updateCenter.get())) {
                UpdatesAction.writePluginUpdateAggregate(jsonWriter, aggregate);
            }
        }
        jsonWriter.endArray();
    }

    private static void writePluginUpdateAggregate(JsonWriter jsonWriter, PluginUpdateAggregator.PluginUpdateAggregate aggregate) {
        jsonWriter.beginObject();
        Plugin plugin = aggregate.getPlugin();
        PluginWSCommons.writePlugin(jsonWriter, plugin);
        UpdatesAction.writeUpdates(jsonWriter, aggregate.getUpdates());
        jsonWriter.endObject();
    }

    private static void writeUpdates(JsonWriter jsonWriter, Collection<PluginUpdate> pluginUpdates) {
        jsonWriter.name(ARRAY_UPDATES).beginArray();
        for (PluginUpdate pluginUpdate : ImmutableSortedSet.copyOf(PLUGIN_UPDATE_BY_VERSION_ORDERING, pluginUpdates)) {
            jsonWriter.beginObject();
            PluginWSCommons.writeRelease(jsonWriter, pluginUpdate.getRelease());
            PluginWSCommons.writeUpdateProperties(jsonWriter, pluginUpdate);
            jsonWriter.endObject();
        }
        jsonWriter.endArray();
    }

    private Collection<PluginUpdateAggregator.PluginUpdateAggregate> retrieveUpdatablePlugins(UpdateCenter updateCenter) {
        List pluginUpdates = updateCenter.findPluginUpdates();
        return ImmutableSortedSet.copyOf(NAME_KEY_PLUGIN_UPGRADE_AGGREGATE_ORDERING, this.aggregator.aggregate(pluginUpdates));
    }
}

