/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.web;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;

public class RootFilter
implements Filter {
    public static final Logger Logger = Loggers.get((String)"http");

    public void init(FilterConfig filterConfig) {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request instanceof HttpServletRequest) {
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            HttpServletResponse httpResponse = (HttpServletResponse)response;
            try {
                chain.doFilter((ServletRequest)new ServletRequestWrapper(httpRequest), (ServletResponse)httpResponse);
            }
            catch (Throwable e) {
                Loggers.get(RootFilter.class).error(String.format("Processing of request %s failed", RootFilter.toUrl(httpRequest)), e);
                if (!response.isCommitted()) {
                    httpResponse.sendError(500);
                }
            }
        } else {
            chain.doFilter(request, response);
        }
    }

    private static String toUrl(HttpServletRequest request) {
        String requestURI = request.getRequestURI();
        String queryString = request.getQueryString();
        if (queryString == null) {
            return requestURI;
        }
        return requestURI + '?' + queryString;
    }

    public void destroy() {
    }

    @VisibleForTesting
    static class ServletRequestWrapper
    extends HttpServletRequestWrapper {
        ServletRequestWrapper(HttpServletRequest request) {
            super(request);
        }

        public HttpSession getSession(boolean create) {
            if (!create) {
                return null;
            }
            throw ServletRequestWrapper.notSupported();
        }

        public HttpSession getSession() {
            throw ServletRequestWrapper.notSupported();
        }

        private static UnsupportedOperationException notSupported() {
            return new UnsupportedOperationException("Sessions are disabled so that web server is stateless");
        }
    }
}

