/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform;

import java.util.Date;
import org.sonar.api.Startable;
import org.sonar.api.server.ServerSide;
import org.sonar.api.utils.DateUtils;
import org.sonar.db.DbClient;
import org.sonar.db.property.PropertyDto;
import org.sonar.server.platform.StartupMetadata;

@ServerSide
public class StartupMetadataPersister
implements Startable {
    private final StartupMetadata metadata;
    private final DbClient dbClient;

    public StartupMetadataPersister(StartupMetadata metadata, DbClient dbClient) {
        this.metadata = metadata;
        this.dbClient = dbClient;
    }

    public void start() {
        String startedAt = DateUtils.formatDateTime((Date)new Date(this.metadata.getStartedAt()));
        this.save("sonar.core.startTime", startedAt);
    }

    private void save(String key, String value) {
        this.dbClient.propertiesDao().saveProperty(new PropertyDto().setKey(key).setValue(value));
    }

    public void stop() {
    }
}

