/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform;

import com.google.common.annotations.VisibleForTesting;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.utils.KeyValueFormat;

public class ServerIdChecksum {
    private static final String SQLSERVER_PREFIX = "jdbc:sqlserver://";

    private ServerIdChecksum() {
    }

    public static String of(String serverId, String jdbcUrl) {
        return DigestUtils.sha256Hex((String)(serverId + "|" + ServerIdChecksum.sanitizeJdbcUrl(jdbcUrl)));
    }

    @VisibleForTesting
    static String sanitizeJdbcUrl(String jdbcUrl) {
        String result = jdbcUrl.startsWith(SQLSERVER_PREFIX) ? ServerIdChecksum.sanitizeSqlServerUrl(jdbcUrl) : StringUtils.substringBefore((String)jdbcUrl, (String)"?");
        return StringUtils.lowerCase((String)result, (Locale)Locale.ENGLISH);
    }

    private static String sanitizeSqlServerUrl(String jdbcUrl) {
        StringBuilder result = new StringBuilder();
        result.append(SQLSERVER_PREFIX);
        String host = jdbcUrl.contains(";") ? StringUtils.substringBetween((String)jdbcUrl, (String)SQLSERVER_PREFIX, (String)";") : StringUtils.substringAfter((String)jdbcUrl, (String)SQLSERVER_PREFIX);
        String queryString = StringUtils.substringAfter((String)jdbcUrl, (String)";");
        Map parameters = KeyValueFormat.parse((String)queryString);
        Optional<String> server = ServerIdChecksum.firstValue(parameters, "serverName", "servername", "server");
        if (server.isPresent()) {
            result.append(server.get());
        } else {
            result.append(StringUtils.substringBefore((String)host, (String)":"));
        }
        Optional<String> port = ServerIdChecksum.firstValue(parameters, "portNumber", "port");
        if (port.isPresent()) {
            result.append(':').append(port.get());
        } else if (host.contains(":")) {
            result.append(':').append(StringUtils.substringAfter((String)host, (String)":"));
        }
        Optional<String> database = ServerIdChecksum.firstValue(parameters, "databaseName", "database");
        database.ifPresent(s -> result.append('/').append((String)s));
        return result.toString();
    }

    private static Optional<String> firstValue(Map<String, String> map, String ... keys) {
        return Arrays.stream(keys).map(map::get).filter(Objects::nonNull).findFirst();
    }
}

