/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.permission.ws.template;

import com.google.common.base.MoreObjects;
import com.google.protobuf.Message;
import java.util.Date;
import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.utils.System2;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.permission.template.PermissionTemplateDto;
import org.sonar.server.permission.PermissionPrivilegeChecker;
import org.sonar.server.permission.ws.PermissionRequestValidator;
import org.sonar.server.permission.ws.PermissionWsSupport;
import org.sonar.server.permission.ws.PermissionsWsAction;
import org.sonar.server.permission.ws.PermissionsWsParametersBuilder;
import org.sonar.server.permission.ws.template.PermissionTemplateDtoToPermissionTemplateResponse;
import org.sonar.server.permission.ws.template.WsTemplateRef;
import org.sonar.server.user.UserSession;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.Permissions;

public class UpdateTemplateAction
implements PermissionsWsAction {
    private final DbClient dbClient;
    private final UserSession userSession;
    private final System2 system;
    private final PermissionWsSupport wsSupport;

    public UpdateTemplateAction(DbClient dbClient, UserSession userSession, System2 system, PermissionWsSupport wsSupport) {
        this.dbClient = dbClient;
        this.userSession = userSession;
        this.system = system;
        this.wsSupport = wsSupport;
    }

    private static UpdateTemplateRequest toUpdateTemplateWsRequest(Request request) {
        return new UpdateTemplateRequest().setId(request.mandatoryParam("id")).setName(request.param("name")).setDescription(request.param("description")).setProjectKeyPattern(request.param("projectKeyPattern"));
    }

    private static Permissions.UpdateTemplateWsResponse buildResponse(PermissionTemplateDto permissionTemplate) {
        Permissions.PermissionTemplate permissionTemplateBuilder = PermissionTemplateDtoToPermissionTemplateResponse.toPermissionTemplateResponse(permissionTemplate);
        return Permissions.UpdateTemplateWsResponse.newBuilder().setPermissionTemplate(permissionTemplateBuilder).build();
    }

    public void define(WebService.NewController context) {
        WebService.NewAction action = context.createAction("update_template").setDescription("Update a permission template.<br />Requires the following permission: 'Administer System'.").setResponseExample(this.getClass().getResource("update_template-example.json")).setSince("5.2").setPost(true).setHandler((RequestHandler)this);
        PermissionsWsParametersBuilder.createIdParameter(action);
        action.createParam("name").setDescription("Name").setExampleValue((Object)"Financial Service Permissions");
        PermissionsWsParametersBuilder.createTemplateProjectKeyPatternParameter(action);
        PermissionsWsParametersBuilder.createTemplateDescriptionParameter(action);
    }

    public void handle(Request request, Response response) throws Exception {
        Permissions.UpdateTemplateWsResponse updateTemplateWsResponse = this.doHandle(UpdateTemplateAction.toUpdateTemplateWsRequest(request));
        WsUtils.writeProtobuf((Message)updateTemplateWsResponse, request, response);
    }

    private Permissions.UpdateTemplateWsResponse doHandle(UpdateTemplateRequest request) {
        String uuid = request.getId();
        String nameParam = request.getName();
        String descriptionParam = request.getDescription();
        String projectPatternParam = request.getProjectKeyPattern();
        try (DbSession dbSession = this.dbClient.openSession(false);){
            PermissionTemplateDto templateToUpdate = this.getAndBuildTemplateToUpdate(dbSession, uuid, nameParam, descriptionParam, projectPatternParam);
            PermissionPrivilegeChecker.checkGlobalAdmin(this.userSession, templateToUpdate.getOrganizationUuid());
            this.validateTemplate(dbSession, templateToUpdate);
            PermissionTemplateDto updatedTemplate = this.updateTemplate(dbSession, templateToUpdate);
            dbSession.commit();
            Permissions.UpdateTemplateWsResponse updateTemplateWsResponse = UpdateTemplateAction.buildResponse(updatedTemplate);
            return updateTemplateWsResponse;
        }
    }

    private void validateTemplate(DbSession dbSession, PermissionTemplateDto templateToUpdate) {
        this.validateTemplateNameForUpdate(dbSession, templateToUpdate.getOrganizationUuid(), templateToUpdate.getName(), templateToUpdate.getId());
        PermissionRequestValidator.validateProjectPattern(templateToUpdate.getKeyPattern());
    }

    private PermissionTemplateDto getAndBuildTemplateToUpdate(DbSession dbSession, String uuid, @Nullable String newName, @Nullable String newDescription, @Nullable String newProjectKeyPattern) {
        PermissionTemplateDto templateToUpdate = this.wsSupport.findTemplate(dbSession, WsTemplateRef.newTemplateRef(uuid, null, null));
        templateToUpdate.setName((String)MoreObjects.firstNonNull((Object)newName, (Object)templateToUpdate.getName()));
        templateToUpdate.setDescription((String)MoreObjects.firstNonNull((Object)newDescription, (Object)templateToUpdate.getDescription()));
        templateToUpdate.setKeyPattern((String)MoreObjects.firstNonNull((Object)newProjectKeyPattern, (Object)templateToUpdate.getKeyPattern()));
        templateToUpdate.setUpdatedAt(new Date(this.system.now()));
        return templateToUpdate;
    }

    private PermissionTemplateDto updateTemplate(DbSession dbSession, PermissionTemplateDto templateToUpdate) {
        return this.dbClient.permissionTemplateDao().update(dbSession, templateToUpdate);
    }

    private void validateTemplateNameForUpdate(DbSession dbSession, String organizationUuid, String name, long id) {
        PermissionRequestValidator.validateTemplateNameFormat(name);
        PermissionTemplateDto permissionTemplateWithSameName = this.dbClient.permissionTemplateDao().selectByName(dbSession, organizationUuid, name);
        WsUtils.checkRequest(permissionTemplateWithSameName == null || permissionTemplateWithSameName.getId() == id, String.format("A template with the name '%s' already exists (case insensitive).", name), new Object[0]);
    }

    private static class UpdateTemplateRequest {
        private String id;
        private String description;
        private String name;
        private String projectKeyPattern;

        private UpdateTemplateRequest() {
        }

        public String getId() {
            return this.id;
        }

        public UpdateTemplateRequest setId(String id) {
            this.id = Objects.requireNonNull(id);
            return this;
        }

        @CheckForNull
        public String getDescription() {
            return this.description;
        }

        public UpdateTemplateRequest setDescription(@Nullable String description) {
            this.description = description;
            return this;
        }

        @CheckForNull
        public String getName() {
            return this.name;
        }

        public UpdateTemplateRequest setName(@Nullable String name) {
            this.name = name;
            return this;
        }

        @CheckForNull
        public String getProjectKeyPattern() {
            return this.projectKeyPattern;
        }

        public UpdateTemplateRequest setProjectKeyPattern(@Nullable String projectKeyPattern) {
            this.projectKeyPattern = projectKeyPattern;
            return this;
        }
    }
}

