/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.permission.ws;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.Optional;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.server.exceptions.NotFoundException;
import org.sonar.server.permission.PermissionChange;
import org.sonar.server.permission.PermissionPrivilegeChecker;
import org.sonar.server.permission.PermissionUpdater;
import org.sonar.server.permission.ProjectId;
import org.sonar.server.permission.UserId;
import org.sonar.server.permission.UserPermissionChange;
import org.sonar.server.permission.ws.PermissionWsSupport;
import org.sonar.server.permission.ws.PermissionsWsAction;
import org.sonar.server.permission.ws.PermissionsWsParametersBuilder;
import org.sonar.server.user.UserSession;

public class AddUserAction
implements PermissionsWsAction {
    public static final String ACTION = "add_user";
    private final DbClient dbClient;
    private final UserSession userSession;
    private final PermissionUpdater permissionUpdater;
    private final PermissionWsSupport support;

    public AddUserAction(DbClient dbClient, UserSession userSession, PermissionUpdater permissionUpdater, PermissionWsSupport support) {
        this.dbClient = dbClient;
        this.userSession = userSession;
        this.permissionUpdater = permissionUpdater;
        this.support = support;
    }

    public void define(WebService.NewController context) {
        WebService.NewAction action = context.createAction(ACTION).setDescription("Add permission to a user.<br /> This service defaults to global permissions, but can be limited to project permissions by providing project id or project key.<br />Requires one of the following permissions:<ul><li>'Administer System'</li><li>'Administer' rights on the specified project</li></ul>").setSince("5.2").setPost(true).setHandler((RequestHandler)this);
        PermissionsWsParametersBuilder.createPermissionParameter(action);
        PermissionsWsParametersBuilder.createUserLoginParameter(action);
        PermissionsWsParametersBuilder.createProjectParameters(action);
        PermissionsWsParametersBuilder.createOrganizationParameter(action).setSince("6.2").setDescription("Key of organization, cannot be used at the same time with %s and %s", new Object[]{"projectId", "projectKey"});
    }

    public void handle(Request request, Response response) throws Exception {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            UserId user = this.support.findUser(dbSession, request.mandatoryParam("login"));
            Optional<ComponentDto> project = this.support.findProject(dbSession, request);
            String organizationKey = request.param("organization");
            Preconditions.checkArgument((!project.isPresent() || organizationKey == null ? 1 : 0) != 0, (Object)"Organization must not be set when project is set.");
            OrganizationDto org = (OrganizationDto)project.map(dto -> this.dbClient.organizationDao().selectByUuid(dbSession, dto.getOrganizationUuid())).orElseGet(() -> Optional.ofNullable(this.support.findOrganization(dbSession, organizationKey))).orElseThrow(() -> new NotFoundException(String.format("Organization with key '%s' not found", organizationKey)));
            this.support.checkMembership(dbSession, org, user);
            Optional<ProjectId> projectId = project.map(ProjectId::new);
            PermissionPrivilegeChecker.checkProjectAdmin(this.userSession, org.getUuid(), projectId);
            UserPermissionChange change = new UserPermissionChange(PermissionChange.Operation.ADD, org.getUuid(), request.mandatoryParam("permission"), projectId.orElse(null), user);
            this.permissionUpdater.apply(dbSession, Collections.singletonList(change));
        }
        response.noContent();
    }
}

