/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.organization.ws;

import java.util.List;
import java.util.Objects;
import org.sonar.api.rule.RuleStatus;
import org.sonar.api.server.ws.Change;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.permission.GroupPermissionDto;
import org.sonar.db.permission.OrganizationPermission;
import org.sonar.db.rule.RuleDefinitionDto;
import org.sonar.db.user.GroupDto;
import org.sonar.db.user.UserGroupDto;
import org.sonar.server.organization.DefaultOrganizationProvider;
import org.sonar.server.organization.OrganizationFlags;
import org.sonar.server.organization.ws.OrganizationsWsAction;
import org.sonar.server.rule.index.RuleIndexer;
import org.sonar.server.user.UserSession;
import org.sonar.server.usergroups.DefaultGroupCreator;
import org.sonar.server.usergroups.DefaultGroupFinder;

public class EnableSupportAction
implements OrganizationsWsAction {
    private static final String ACTION = "enable_support";
    private final UserSession userSession;
    private final DbClient dbClient;
    private final DefaultOrganizationProvider defaultOrganizationProvider;
    private final OrganizationFlags organizationFlags;
    private final DefaultGroupCreator defaultGroupCreator;
    private final DefaultGroupFinder defaultGroupFinder;
    private final RuleIndexer ruleIndexer;

    public EnableSupportAction(UserSession userSession, DbClient dbClient, DefaultOrganizationProvider defaultOrganizationProvider, OrganizationFlags organizationFlags, DefaultGroupCreator defaultGroupCreator, DefaultGroupFinder defaultGroupFinder, RuleIndexer ruleIndexer) {
        this.userSession = userSession;
        this.dbClient = dbClient;
        this.defaultOrganizationProvider = defaultOrganizationProvider;
        this.organizationFlags = organizationFlags;
        this.defaultGroupCreator = defaultGroupCreator;
        this.defaultGroupFinder = defaultGroupFinder;
        this.ruleIndexer = ruleIndexer;
    }

    public void define(WebService.NewController context) {
        context.createAction(ACTION).setPost(true).setDescription("Enable support of organizations.<br />'Administer System' permission is required. The logged-in user will be flagged as root and will be able to manage organizations and other root users.").setInternal(true).setPost(true).setSince("6.3").setChangelog(new Change[]{new Change("6.4", "Create default 'Members' group")}).setHandler((RequestHandler)this);
    }

    public void handle(Request request, Response response) throws Exception {
        this.verifySystemAdministrator();
        try (DbSession dbSession = this.dbClient.openSession(false);){
            if (this.isSupportDisabled(dbSession)) {
                this.flagCurrentUserAsRoot(dbSession);
                this.createDefaultMembersGroup(dbSession);
                List<Integer> disabledTemplateAndCustomRuleIds = this.disableTemplateRulesAndCustomRules(dbSession);
                this.enableFeature(dbSession);
                this.ruleIndexer.commitAndIndex(dbSession, disabledTemplateAndCustomRuleIds);
            }
        }
        response.noContent();
    }

    private void verifySystemAdministrator() {
        this.userSession.checkLoggedIn().checkPermission(OrganizationPermission.ADMINISTER, this.defaultOrganizationProvider.get().getUuid());
    }

    private boolean isSupportDisabled(DbSession dbSession) {
        return !this.organizationFlags.isEnabled(dbSession);
    }

    private void flagCurrentUserAsRoot(DbSession dbSession) {
        this.dbClient.userDao().setRoot(dbSession, Objects.requireNonNull(this.userSession.getLogin()), true);
    }

    private void createDefaultMembersGroup(DbSession dbSession) {
        String defaultOrganizationUuid = this.defaultOrganizationProvider.get().getUuid();
        GroupDto sonarUsersGroupId = this.defaultGroupFinder.findDefaultGroup(dbSession, defaultOrganizationUuid);
        GroupDto members = this.defaultGroupCreator.create(dbSession, defaultOrganizationUuid);
        this.copySonarUsersGroupPermissionsToMembersGroup(dbSession, sonarUsersGroupId, members);
        this.copySonarUsersGroupPermissionTemplatesToMembersGroup(dbSession, sonarUsersGroupId, members);
        this.associateMembersOfDefaultOrganizationToGroup(dbSession, members);
    }

    private void associateMembersOfDefaultOrganizationToGroup(DbSession dbSession, GroupDto membersGroup) {
        List organizationMembers = this.dbClient.organizationMemberDao().selectUserIdsByOrganizationUuid(dbSession, this.defaultOrganizationProvider.get().getUuid());
        organizationMembers.forEach(member -> this.dbClient.userGroupDao().insert(dbSession, new UserGroupDto().setGroupId(membersGroup.getId().intValue()).setUserId(member.intValue())));
    }

    private void copySonarUsersGroupPermissionsToMembersGroup(DbSession dbSession, GroupDto sonarUsersGroup, GroupDto membersGroup) {
        String defaultOrganizationUuid = this.defaultOrganizationProvider.get().getUuid();
        this.dbClient.groupPermissionDao().selectAllPermissionsByGroupId(dbSession, defaultOrganizationUuid, sonarUsersGroup.getId(), context -> {
            GroupPermissionDto groupPermissionDto = (GroupPermissionDto)context.getResultObject();
            this.dbClient.groupPermissionDao().insert(dbSession, new GroupPermissionDto().setOrganizationUuid(defaultOrganizationUuid).setGroupId(membersGroup.getId()).setRole(groupPermissionDto.getRole()).setResourceId(groupPermissionDto.getResourceId()));
        });
    }

    private void copySonarUsersGroupPermissionTemplatesToMembersGroup(DbSession dbSession, GroupDto sonarUsersGroup, GroupDto membersGroup) {
        List sonarUsersPermissionTemplates = this.dbClient.permissionTemplateDao().selectAllGroupPermissionTemplatesByGroupId(dbSession, (long)sonarUsersGroup.getId().intValue());
        sonarUsersPermissionTemplates.forEach(permissionTemplateGroup -> this.dbClient.permissionTemplateDao().insertGroupPermission(dbSession, permissionTemplateGroup.getTemplateId().longValue(), membersGroup.getId(), permissionTemplateGroup.getPermission()));
    }

    public List<Integer> disableTemplateRulesAndCustomRules(DbSession dbSession) {
        List rules = (List)this.dbClient.ruleDao().selectAllDefinitions(dbSession).stream().filter(r -> r.isTemplate() || r.isCustomRule()).collect(MoreCollectors.toList());
        rules.forEach(r -> {
            r.setStatus(RuleStatus.REMOVED);
            this.dbClient.ruleDao().update(dbSession, r);
        });
        return (List)rules.stream().map(RuleDefinitionDto::getId).collect(MoreCollectors.toList());
    }

    private void enableFeature(DbSession dbSession) {
        this.organizationFlags.enable(dbSession);
    }
}

