/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.organization.ws;

import com.google.common.base.Strings;
import com.google.protobuf.Message;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.core.util.Protobuf;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.organization.OrganizationMemberDto;
import org.sonar.db.permission.OrganizationPermission;
import org.sonar.db.user.GroupMembershipQuery;
import org.sonar.db.user.UserDto;
import org.sonar.db.user.UserGroupDto;
import org.sonar.server.issue.ws.AvatarResolver;
import org.sonar.server.organization.ws.OrganizationsWsAction;
import org.sonar.server.user.UserSession;
import org.sonar.server.user.index.UserIndexer;
import org.sonar.server.usergroups.DefaultGroupFinder;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.Organizations;

public class AddMemberAction
implements OrganizationsWsAction {
    private final DbClient dbClient;
    private final UserSession userSession;
    private final UserIndexer userIndexer;
    private final DefaultGroupFinder defaultGroupFinder;
    private final AvatarResolver avatarResolver;

    public AddMemberAction(DbClient dbClient, UserSession userSession, UserIndexer userIndexer, DefaultGroupFinder defaultGroupFinder, AvatarResolver avatarResolver) {
        this.dbClient = dbClient;
        this.userSession = userSession;
        this.userIndexer = userIndexer;
        this.defaultGroupFinder = defaultGroupFinder;
        this.avatarResolver = avatarResolver;
    }

    public void define(WebService.NewController context) {
        WebService.NewAction action = context.createAction("add_member").setDescription("Add a user as a member of an organization.<br>Requires 'Administer System' permission on the specified organization.").setSince("6.4").setPost(true).setInternal(true).setResponseExample(this.getClass().getResource("add_member-example.json")).setHandler((RequestHandler)this);
        action.createParam("organization").setDescription("Organization key").setRequired(true).setExampleValue((Object)"my-org");
        action.createParam("login").setDescription("User login").setRequired(true).setExampleValue((Object)"ray.bradbury");
    }

    public void handle(Request request, Response response) throws Exception {
        String organizationKey = request.mandatoryParam("organization");
        String login = request.mandatoryParam("login");
        try (DbSession dbSession = this.dbClient.openSession(false);){
            OrganizationDto organization = (OrganizationDto)WsUtils.checkFoundWithOptional(this.dbClient.organizationDao().selectByKey(dbSession, organizationKey), "Organization '%s' is not found", organizationKey);
            UserDto user = WsUtils.checkFound(this.dbClient.userDao().selectByLogin(dbSession, login), "User '%s' is not found", login);
            this.addMember(dbSession, organization, user);
            int groups = this.dbClient.groupMembershipDao().countGroups(dbSession, GroupMembershipQuery.builder().organizationUuid(organization.getUuid()).membership("IN").build(), user.getId());
            Organizations.AddMemberWsResponse wsResponse = this.buildResponse(user, groups);
            WsUtils.writeProtobuf((Message)wsResponse, request, response);
        }
    }

    private void addMember(DbSession dbSession, OrganizationDto organization, UserDto user) {
        this.userSession.checkPermission(OrganizationPermission.ADMINISTER, organization);
        if (this.isMemberOf(dbSession, organization, user)) {
            return;
        }
        this.dbClient.organizationMemberDao().insert(dbSession, new OrganizationMemberDto().setOrganizationUuid(organization.getUuid()).setUserId(user.getId()));
        this.dbClient.userGroupDao().insert(dbSession, new UserGroupDto().setGroupId(this.defaultGroupFinder.findDefaultGroup(dbSession, organization.getUuid()).getId().intValue()).setUserId(user.getId().intValue()));
        this.userIndexer.commitAndIndex(dbSession, user);
    }

    private Organizations.AddMemberWsResponse buildResponse(UserDto user, int groups) {
        Organizations.AddMemberWsResponse.Builder response = Organizations.AddMemberWsResponse.newBuilder();
        Organizations.User.Builder wsUser = Organizations.User.newBuilder().setLogin(user.getLogin()).setName(user.getName()).setGroupCount(groups);
        Protobuf.setNullable((Object)Strings.emptyToNull((String)user.getEmail()), text -> wsUser.setAvatar(this.avatarResolver.create(user)));
        response.setUser(wsUser);
        return response.build();
    }

    private boolean isMemberOf(DbSession dbSession, OrganizationDto organizationDto, UserDto userDto) {
        return this.dbClient.organizationMemberDao().select(dbSession, organizationDto.getUuid(), userDto.getId().intValue()).isPresent();
    }
}

