/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.notification.ws;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.sonar.api.notifications.NotificationChannel;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.core.util.Protobuf;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.user.UserDto;
import org.sonar.server.component.ComponentFinder;
import org.sonar.server.notification.NotificationCenter;
import org.sonar.server.notification.NotificationUpdater;
import org.sonar.server.notification.email.EmailNotificationChannel;
import org.sonar.server.notification.ws.Dispatchers;
import org.sonar.server.notification.ws.NotificationsWsAction;
import org.sonar.server.user.UserSession;
import org.sonar.server.ws.WsUtils;

public class RemoveAction
implements NotificationsWsAction {
    private final NotificationCenter notificationCenter;
    private final NotificationUpdater notificationUpdater;
    private final Dispatchers dispatchers;
    private final DbClient dbClient;
    private final ComponentFinder componentFinder;
    private final UserSession userSession;

    public RemoveAction(NotificationCenter notificationCenter, NotificationUpdater notificationUpdater, Dispatchers dispatchers, DbClient dbClient, ComponentFinder componentFinder, UserSession userSession) {
        this.notificationCenter = notificationCenter;
        this.notificationUpdater = notificationUpdater;
        this.dispatchers = dispatchers;
        this.dbClient = dbClient;
        this.componentFinder = componentFinder;
        this.userSession = userSession;
    }

    public void define(WebService.NewController context) {
        WebService.NewAction action = context.createAction("remove").setDescription("Remove a notification for the authenticated user.<br>Requires one of the following permissions:<ul>  <li>Authentication if no login is provided</li>  <li>System administration if a login is provided</li></ul>").setSince("6.3").setPost(true).setHandler((RequestHandler)this);
        action.createParam("project").setDescription("Project key").setExampleValue((Object)"my_project");
        List<NotificationChannel> channels = this.notificationCenter.getChannels();
        action.createParam("channel").setDescription("Channel through which the notification is sent. For example, notifications can be sent by email.").setPossibleValues(channels).setDefaultValue((Object)EmailNotificationChannel.class.getSimpleName());
        action.createParam("type").setDescription("Notification type. Possible values are for:<ul>  <li>Global notifications: %s</li>  <li>Per project notifications: %s</li></ul>", new Object[]{this.dispatchers.getGlobalDispatchers().stream().sorted().collect(Collectors.joining(", ")), this.dispatchers.getProjectDispatchers().stream().sorted().collect(Collectors.joining(", "))}).setRequired(true).setExampleValue((Object)"SQ-MyNewIssues");
        action.createParam("login").setDescription("User login").setSince("6.4");
    }

    public void handle(Request request, Response response) throws Exception {
        RemoveRequest removeRequest = this.toWsRequest(request);
        this.remove(removeRequest);
        response.noContent();
    }

    private void remove(RemoveRequest request) {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            this.checkPermissions(request);
            UserDto user = this.getUser(dbSession, request);
            Optional<ComponentDto> project = this.searchProject(dbSession, request);
            this.notificationUpdater.remove(dbSession, request.getChannel(), request.getType(), user, project.orElse(null));
            dbSession.commit();
        }
    }

    private UserDto getUser(DbSession dbSession, RemoveRequest request) {
        String login = request.getLogin() == null ? this.userSession.getLogin() : request.getLogin();
        return WsUtils.checkFound(this.dbClient.userDao().selectByLogin(dbSession, login), "User '%s' not found", login);
    }

    private Optional<ComponentDto> searchProject(DbSession dbSession, RemoveRequest request) {
        Optional<ComponentDto> project = request.getProject() == null ? Optional.empty() : Optional.of(this.componentFinder.getByKey(dbSession, request.getProject()));
        project.ifPresent(p -> WsUtils.checkRequest("TRK".equals(p.qualifier()) && "PRJ".equals(p.scope()), "Component '%s' must be a project", request.getProject()));
        return project;
    }

    private void checkPermissions(RemoveRequest request) {
        if (request.getLogin() == null) {
            this.userSession.checkLoggedIn();
        } else {
            this.userSession.checkIsSystemAdministrator();
        }
    }

    private RemoveRequest toWsRequest(Request request) {
        RemoveRequest remove = new RemoveRequest().setType(request.mandatoryParam("type")).setChannel(request.mandatoryParam("channel"));
        Protobuf.setNullable((Object)request.param("project"), remove::setProject);
        Protobuf.setNullable((Object)request.param("login"), remove::setLogin);
        if (remove.getProject() == null) {
            WsUtils.checkRequest(this.dispatchers.getGlobalDispatchers().contains(remove.getType()), "Value of parameter '%s' (%s) must be one of: %s", "type", remove.getType(), this.dispatchers.getGlobalDispatchers());
        } else {
            WsUtils.checkRequest(this.dispatchers.getProjectDispatchers().contains(remove.getType()), "Value of parameter '%s' (%s) must be one of: %s", "type", remove.getType(), this.dispatchers.getProjectDispatchers());
        }
        return remove;
    }

    static class RemoveRequest {
        private String channel;
        private String login;
        private String project;
        private String type;

        RemoveRequest() {
        }

        public RemoveRequest setChannel(String channel) {
            this.channel = channel;
            return this;
        }

        public String getChannel() {
            return this.channel;
        }

        public RemoveRequest setLogin(String login) {
            this.login = login;
            return this;
        }

        public String getLogin() {
            return this.login;
        }

        public RemoveRequest setProject(String project) {
            this.project = project;
            return this;
        }

        public String getProject() {
            return this.project;
        }

        public RemoveRequest setType(String type) {
            this.type = type;
            return this;
        }

        public String getType() {
            return this.type;
        }
    }
}

