/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.notification;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.property.PropertyDto;
import org.sonar.db.property.PropertyQuery;
import org.sonar.db.user.UserDto;

public class NotificationUpdater {
    private static final String PROP_NOTIFICATION_PREFIX = "notification";
    private static final String PROP_NOTIFICATION_VALUE = "true";
    private final DbClient dbClient;

    public NotificationUpdater(DbClient dbClient) {
        this.dbClient = dbClient;
    }

    public void add(DbSession dbSession, String channel, String dispatcher, UserDto user, @Nullable ComponentDto project) {
        String key = String.join((CharSequence)".", PROP_NOTIFICATION_PREFIX, dispatcher, channel);
        Long projectId = project == null ? null : project.getId();
        List existingNotification = (List)this.dbClient.propertiesDao().selectByQuery(PropertyQuery.builder().setKey(key).setComponentId(projectId).setUserId(user.getId()).build(), dbSession).stream().filter(NotificationUpdater.notificationScope(project)).collect(MoreCollectors.toList());
        Preconditions.checkArgument((existingNotification.isEmpty() || !PROP_NOTIFICATION_VALUE.equals(((PropertyDto)existingNotification.get(0)).getValue()) ? 1 : 0) != 0, (Object)"Notification already added");
        this.dbClient.propertiesDao().saveProperty(dbSession, new PropertyDto().setKey(key).setUserId(user.getId()).setValue(PROP_NOTIFICATION_VALUE).setResourceId(projectId));
    }

    public void remove(DbSession dbSession, String channel, String dispatcher, UserDto user, @Nullable ComponentDto project) {
        String key = String.join((CharSequence)".", PROP_NOTIFICATION_PREFIX, dispatcher, channel);
        Long projectId = project == null ? null : project.getId();
        List existingNotification = (List)this.dbClient.propertiesDao().selectByQuery(PropertyQuery.builder().setKey(key).setComponentId(projectId).setUserId(user.getId()).build(), dbSession).stream().filter(NotificationUpdater.notificationScope(project)).collect(MoreCollectors.toList());
        Preconditions.checkArgument((!existingNotification.isEmpty() && PROP_NOTIFICATION_VALUE.equals(((PropertyDto)existingNotification.get(0)).getValue()) ? 1 : 0) != 0, (Object)"Notification doesn't exist");
        this.dbClient.propertiesDao().delete(dbSession, new PropertyDto().setKey(key).setUserId(user.getId()).setValue(PROP_NOTIFICATION_VALUE).setResourceId(projectId));
    }

    private static Predicate<PropertyDto> notificationScope(@Nullable ComponentDto project) {
        return prop -> project == null ? prop.getResourceId() == null : prop.getResourceId() != null;
    }
}

