/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.metric.ws;

import java.util.List;
import javax.annotation.Nullable;
import org.sonar.api.measures.Metric;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.utils.text.JsonWriter;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.measure.custom.CustomMeasureDto;
import org.sonar.db.metric.MetricDto;
import org.sonar.server.metric.ws.MetricsWsAction;
import org.sonar.server.user.UserSession;
import org.sonar.server.util.MetricKeyValidator;
import org.sonar.server.ws.WsUtils;

public class UpdateAction
implements MetricsWsAction {
    private static final String ACTION = "update";
    public static final String PARAM_ID = "id";
    public static final String PARAM_NAME = "name";
    public static final String PARAM_KEY = "key";
    public static final String PARAM_TYPE = "type";
    public static final String PARAM_DESCRIPTION = "description";
    public static final String PARAM_DOMAIN = "domain";
    private static final String FIELD_ID = "id";
    private static final String FIELD_NAME = "name";
    private static final String FIELD_KEY = "key";
    private static final String FIELD_TYPE = "type";
    private static final String FIELD_DESCRIPTION = "description";
    private static final String FIELD_DOMAIN = "domain";
    private final DbClient dbClient;
    private final UserSession userSession;

    public UpdateAction(DbClient dbClient, UserSession userSession) {
        this.dbClient = dbClient;
        this.userSession = userSession;
    }

    public void define(WebService.NewController context) {
        WebService.NewAction action = context.createAction(ACTION).setPost(true).setDescription("Update a custom metric.<br /> Requires 'Administer System' permission.").setSince("5.2").setHandler((RequestHandler)this);
        action.createParam("id").setRequired(true).setDescription("Id of the custom metric to update").setExampleValue((Object)"42");
        action.createParam("key").setDescription("Key").setMaximumLength(Integer.valueOf(64)).setDescription("Key").setExampleValue((Object)"team_size");
        action.createParam("name").setMaximumLength(Integer.valueOf(64)).setDescription("Name");
        action.createParam("type").setDescription("Metric type key").setPossibleValues((Object[])Metric.ValueType.names()).setExampleValue((Object)Metric.ValueType.INT.name());
        action.createParam("description").setDescription("Description").setMaximumLength(Integer.valueOf(255)).setExampleValue((Object)"Size of the team");
        action.createParam("domain").setMaximumLength(Integer.valueOf(64)).setDescription("Domain").setExampleValue((Object)"Tests");
    }

    public void handle(Request request, Response response) throws Exception {
        this.userSession.checkLoggedIn().checkIsSystemAdministrator();
        int id = request.mandatoryParamAsInt("id");
        try (DbSession dbSession = this.dbClient.openSession(false);){
            MetricDto metricTemplate = UpdateAction.newMetricTemplate(request);
            MetricDto metricInDb = this.dbClient.metricDao().selectById(dbSession, (long)id);
            this.checkMetricInDbAndTemplate(dbSession, metricInDb, metricTemplate);
            this.updateMetricInDb(dbSession, metricInDb, metricTemplate);
            JsonWriter json = response.newJsonWriter();
            UpdateAction.writeMetric(json, metricInDb);
            json.close();
        }
    }

    private static MetricDto newMetricTemplate(Request request) {
        int id = request.mandatoryParamAsInt("id");
        String key = request.param("key");
        if (key != null) {
            MetricKeyValidator.checkMetricKeyFormat(key);
        }
        String type = request.param("type");
        String name = request.param("name");
        String domain = request.param("domain");
        String description = request.param("description");
        MetricDto metricTemplate = new MetricDto().setId(Integer.valueOf(id));
        if (key != null) {
            metricTemplate.setKey(key);
        }
        if (type != null) {
            metricTemplate.setValueType(type);
        }
        if (name != null) {
            metricTemplate.setShortName(name);
        }
        if (domain != null) {
            metricTemplate.setDomain(domain);
        }
        if (description != null) {
            metricTemplate.setDescription(description);
        }
        return metricTemplate;
    }

    private void updateMetricInDb(DbSession dbSession, MetricDto metricInDb, MetricDto metricTemplate) {
        String key = metricTemplate.getKey();
        String name = metricTemplate.getShortName();
        String type = metricTemplate.getValueType();
        String domain = metricTemplate.getDomain();
        String description = metricTemplate.getDescription();
        if (key != null) {
            metricInDb.setKey(key);
        }
        if (name != null) {
            metricInDb.setShortName(name);
        }
        if (type != null) {
            metricInDb.setValueType(type);
        }
        if (domain != null) {
            metricInDb.setDomain(domain);
        }
        if (description != null) {
            metricInDb.setDescription(description);
        }
        this.dbClient.metricDao().update(dbSession, metricInDb);
        dbSession.commit();
    }

    private void checkMetricInDbAndTemplate(DbSession dbSession, @Nullable MetricDto metricInDb, MetricDto template) {
        WsUtils.checkRequest(UpdateAction.isMetricFoundInDb(metricInDb) && !UpdateAction.isMetricDisabled(metricInDb) && UpdateAction.isMetricCustom(metricInDb), "No active custom metric has been found for id '%d'.", template.getId());
        this.checkNoOtherMetricWithTargetKey(dbSession, metricInDb, template);
        if (UpdateAction.haveMetricTypeChanged(metricInDb, template)) {
            List customMeasures = this.dbClient.customMeasureDao().selectByMetricId(dbSession, metricInDb.getId().intValue());
            WsUtils.checkRequest(!UpdateAction.haveAssociatedCustomMeasures(customMeasures), "You're trying to change the type '%s' while there are associated custom measures.", metricInDb.getValueType());
        }
    }

    private void checkNoOtherMetricWithTargetKey(DbSession dbSession, MetricDto metricInDb, MetricDto template) {
        String targetKey = template.getKey();
        MetricDto metricWithTargetKey = this.dbClient.metricDao().selectByKey(dbSession, targetKey);
        WsUtils.checkRequest(!UpdateAction.isMetricFoundInDb(metricWithTargetKey) || metricInDb.getId().equals(metricWithTargetKey.getId()), "The key '%s' is already used by an existing metric.", targetKey);
    }

    private static void writeMetric(JsonWriter json, MetricDto metric) {
        json.beginObject();
        json.prop("id", String.valueOf(metric.getId()));
        json.prop("key", metric.getKey());
        json.prop("type", metric.getValueType());
        json.prop("name", metric.getShortName());
        json.prop("domain", metric.getDomain());
        json.prop("description", metric.getDescription());
        json.endObject();
    }

    private static boolean isMetricCustom(MetricDto metricInDb) {
        return metricInDb.isUserManaged();
    }

    private static boolean isMetricDisabled(MetricDto metricInDb) {
        return !metricInDb.isEnabled();
    }

    private static boolean isMetricFoundInDb(@Nullable MetricDto metricInDb) {
        return metricInDb != null;
    }

    private static boolean haveAssociatedCustomMeasures(List<CustomMeasureDto> customMeasures) {
        return !customMeasures.isEmpty();
    }

    private static boolean haveMetricTypeChanged(MetricDto metricInDb, MetricDto template) {
        return !metricInDb.getValueType().equals(template.getValueType()) && template.getValueType() != null;
    }
}

