/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.measure.ws;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.Map;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.sonar.api.utils.DateUtils;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.component.SnapshotDto;
import org.sonar.db.measure.MeasureDto;
import org.sonar.db.metric.MetricDto;
import org.sonar.server.measure.ws.MeasureValueFormatter;
import org.sonar.server.measure.ws.SearchHistoryResult;
import org.sonarqube.ws.Measures;

class SearchHistoryResponseFactory {
    private final SearchHistoryResult result;
    private final Measures.SearchHistoryResponse.HistoryMeasure.Builder measure;
    private final Measures.SearchHistoryResponse.HistoryValue.Builder value;

    SearchHistoryResponseFactory(SearchHistoryResult result) {
        this.result = result;
        this.measure = Measures.SearchHistoryResponse.HistoryMeasure.newBuilder();
        this.value = Measures.SearchHistoryResponse.HistoryValue.newBuilder();
    }

    public Measures.SearchHistoryResponse apply() {
        return (Measures.SearchHistoryResponse)Stream.of(Measures.SearchHistoryResponse.newBuilder()).map(this.addPaging()).map(this.addMeasures()).map(Measures.SearchHistoryResponse.Builder::build).collect(MoreCollectors.toOneElement());
    }

    private UnaryOperator<Measures.SearchHistoryResponse.Builder> addPaging() {
        return response -> response.setPaging(this.result.getPaging());
    }

    private UnaryOperator<Measures.SearchHistoryResponse.Builder> addMeasures() {
        Map metricsById = (Map)this.result.getMetrics().stream().collect(MoreCollectors.uniqueIndex(MetricDto::getId));
        Map analysesByUuid = (Map)this.result.getAnalyses().stream().collect(MoreCollectors.uniqueIndex(SnapshotDto::getUuid));
        HashBasedTable measuresByMetricByAnalysis = HashBasedTable.create((int)this.result.getMetrics().size(), (int)this.result.getAnalyses().size());
        this.result.getMeasures().forEach(arg_0 -> SearchHistoryResponseFactory.lambda$addMeasures$1((Table)measuresByMetricByAnalysis, metricsById, analysesByUuid, arg_0));
        return arg_0 -> this.lambda$addMeasures$4((Table)measuresByMetricByAnalysis, arg_0);
    }

    private UnaryOperator<MetricDto> addMetric() {
        return metric -> {
            this.measure.setMetric(metric.getKey());
            return metric;
        };
    }

    private UnaryOperator<MetricDto> addValues(Map<SnapshotDto, MeasureDto> measuresByAnalysis) {
        return metric -> {
            this.result.getAnalyses().stream().map(this.clearValue()).map(this.addDate()).map(analysis -> this.addValue((SnapshotDto)analysis, (MetricDto)metric, (MeasureDto)measuresByAnalysis.get(analysis))).forEach(analysis -> this.measure.addHistory(this.value));
            return metric;
        };
    }

    private UnaryOperator<SnapshotDto> addDate() {
        return analysis -> {
            this.value.setDate(DateUtils.formatDateTime((long)analysis.getCreatedAt()));
            return analysis;
        };
    }

    private SnapshotDto addValue(SnapshotDto analysis, MetricDto dbMetric, @Nullable MeasureDto dbMeasure) {
        if (dbMeasure != null) {
            String measureValue = dbMetric.getKey().startsWith("new_") ? MeasureValueFormatter.formatNumericalValue(dbMeasure.getVariation(), dbMetric) : MeasureValueFormatter.formatMeasureValue(dbMeasure, dbMetric);
            this.value.setValue(measureValue);
        }
        return analysis;
    }

    private UnaryOperator<MetricDto> clearMetric() {
        return metric -> {
            this.measure.clear();
            return metric;
        };
    }

    private UnaryOperator<SnapshotDto> clearValue() {
        return analysis -> {
            this.value.clear();
            return analysis;
        };
    }

    private /* synthetic */ Measures.SearchHistoryResponse.Builder lambda$addMeasures$4(Table measuresByMetricByAnalysis, Measures.SearchHistoryResponse.Builder response) {
        this.result.getMetrics().stream().map(this.clearMetric()).map(this.addMetric()).map(metric -> (MetricDto)this.addValues(measuresByMetricByAnalysis.row(metric)).apply((MetricDto)metric)).forEach(metric -> response.addMeasures(this.measure));
        return response;
    }

    private static /* synthetic */ void lambda$addMeasures$1(Table measuresByMetricByAnalysis, Map metricsById, Map analysesByUuid, MeasureDto m) {
        MeasureDto cfr_ignored_0 = (MeasureDto)measuresByMetricByAnalysis.put(metricsById.get(m.getMetricId()), analysesByUuid.get(m.getAnalysisUuid()), (Object)m);
    }
}

