/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.measure.live;

import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.function.BiConsumer;
import org.sonar.api.measures.Metric;
import org.sonar.db.component.ComponentDto;
import org.sonar.server.computation.task.projectanalysis.qualitymodel.DebtRatingGrid;
import org.sonar.server.computation.task.projectanalysis.qualitymodel.Rating;
import org.sonar.server.measure.live.IssueCounter;

class IssueMetricFormula {
    private final Metric metric;
    private final boolean onLeak;
    private final BiConsumer<Context, IssueCounter> formula;
    private final Collection<Metric> dependentMetrics;

    IssueMetricFormula(Metric metric, boolean onLeak, BiConsumer<Context, IssueCounter> formula) {
        this(metric, onLeak, formula, Collections.emptyList());
    }

    IssueMetricFormula(Metric metric, boolean onLeak, BiConsumer<Context, IssueCounter> formula, Collection<Metric> dependentMetrics) {
        this.metric = metric;
        this.onLeak = onLeak;
        this.formula = formula;
        this.dependentMetrics = dependentMetrics;
    }

    Metric getMetric() {
        return this.metric;
    }

    boolean isOnLeak() {
        return this.onLeak;
    }

    Collection<Metric> getDependentMetrics() {
        return this.dependentMetrics;
    }

    void compute(Context context, IssueCounter issues) {
        this.formula.accept(context, issues);
    }

    static interface Context {
        public ComponentDto getComponent();

        public DebtRatingGrid getDebtRatingGrid();

        public Optional<Double> getValue(Metric var1);

        public Optional<Double> getLeakValue(Metric var1);

        public void setValue(double var1);

        public void setValue(Rating var1);

        public void setLeakValue(double var1);

        public void setLeakValue(Rating var1);
    }
}

