/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.measure.index;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.elasticsearch.action.index.IndexRequest;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.es.EsQueueDto;
import org.sonar.db.measure.ProjectMeasuresIndexerIterator;
import org.sonar.server.es.BulkIndexer;
import org.sonar.server.es.EsClient;
import org.sonar.server.es.IndexType;
import org.sonar.server.es.IndexingListener;
import org.sonar.server.es.IndexingResult;
import org.sonar.server.es.OneToOneResilientIndexingListener;
import org.sonar.server.es.ProjectIndexer;
import org.sonar.server.measure.index.ProjectMeasuresDoc;
import org.sonar.server.measure.index.ProjectMeasuresIndexDefinition;
import org.sonar.server.permission.index.AuthorizationScope;
import org.sonar.server.permission.index.NeedAuthorizationIndexer;

public class ProjectMeasuresIndexer
implements ProjectIndexer,
NeedAuthorizationIndexer {
    private static final AuthorizationScope AUTHORIZATION_SCOPE = new AuthorizationScope(ProjectMeasuresIndexDefinition.INDEX_TYPE_PROJECT_MEASURES, project -> "TRK".equals(project.getQualifier()));
    private static final ImmutableSet<IndexType> INDEX_TYPES = ImmutableSet.of((Object)ProjectMeasuresIndexDefinition.INDEX_TYPE_PROJECT_MEASURES);
    private final DbClient dbClient;
    private final EsClient esClient;

    public ProjectMeasuresIndexer(DbClient dbClient, EsClient esClient) {
        this.dbClient = dbClient;
        this.esClient = esClient;
    }

    @Override
    public Set<IndexType> getIndexTypes() {
        return INDEX_TYPES;
    }

    @Override
    public void indexOnStartup(Set<IndexType> uninitializedIndexTypes) {
        this.doIndex(BulkIndexer.Size.LARGE, null);
    }

    @Override
    public AuthorizationScope getAuthorizationScope() {
        return AUTHORIZATION_SCOPE;
    }

    @Override
    public void indexOnAnalysis(String projectUuid) {
        this.doIndex(BulkIndexer.Size.REGULAR, projectUuid);
    }

    @Override
    public Collection<EsQueueDto> prepareForRecovery(DbSession dbSession, Collection<String> projectUuids, ProjectIndexer.Cause cause) {
        switch (cause) {
            case PERMISSION_CHANGE: {
                return Collections.emptyList();
            }
            case MEASURE_CHANGE: 
            case PROJECT_KEY_UPDATE: 
            case PROJECT_CREATION: 
            case PROJECT_TAGS_UPDATE: 
            case PROJECT_DELETION: {
                List items = (List)projectUuids.stream().map(projectUuid -> EsQueueDto.create((String)ProjectMeasuresIndexDefinition.INDEX_TYPE_PROJECT_MEASURES.format(), (String)projectUuid, null, (String)projectUuid)).collect(MoreCollectors.toArrayList((int)projectUuids.size()));
                return this.dbClient.esQueueDao().insert(dbSession, (Collection)items);
            }
        }
        throw new IllegalStateException("Unsupported cause: " + (Object)((Object)cause));
    }

    public IndexingResult commitAndIndex(DbSession dbSession, Collection<String> projectUuids) {
        List items = (List)projectUuids.stream().map(projectUuid -> EsQueueDto.create((String)ProjectMeasuresIndexDefinition.INDEX_TYPE_PROJECT_MEASURES.format(), (String)projectUuid, null, (String)projectUuid)).collect(MoreCollectors.toArrayList((int)projectUuids.size()));
        this.dbClient.esQueueDao().insert(dbSession, (Collection)items);
        dbSession.commit();
        return this.index(dbSession, items);
    }

    @Override
    public IndexingResult index(DbSession dbSession, Collection<EsQueueDto> items) {
        if (items.isEmpty()) {
            return new IndexingResult();
        }
        OneToOneResilientIndexingListener listener = new OneToOneResilientIndexingListener(this.dbClient, dbSession, items);
        BulkIndexer bulkIndexer = this.createBulkIndexer(BulkIndexer.Size.REGULAR, listener);
        bulkIndexer.start();
        List projectUuids = (List)items.stream().map(EsQueueDto::getDocId).collect(MoreCollectors.toArrayList((int)items.size()));
        Iterator it = projectUuids.iterator();
        while (it.hasNext()) {
            String projectUuid2 = (String)it.next();
            ProjectMeasuresIndexerIterator rowIt = ProjectMeasuresIndexerIterator.create((DbSession)dbSession, (String)projectUuid2);
            Throwable throwable = null;
            try {
                while (rowIt.hasNext()) {
                    bulkIndexer.add(ProjectMeasuresIndexer.newIndexRequest(ProjectMeasuresIndexer.toProjectMeasuresDoc((ProjectMeasuresIndexerIterator.ProjectMeasures)rowIt.next())));
                    it.remove();
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (rowIt == null) continue;
                if (throwable != null) {
                    try {
                        rowIt.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                rowIt.close();
            }
        }
        projectUuids.forEach(projectUuid -> bulkIndexer.addDeletion(ProjectMeasuresIndexDefinition.INDEX_TYPE_PROJECT_MEASURES, (String)projectUuid, (String)projectUuid));
        return bulkIndexer.stop();
    }

    private void doIndex(BulkIndexer.Size size, @Nullable String projectUuid) {
        try (DbSession dbSession = this.dbClient.openSession(false);
             ProjectMeasuresIndexerIterator rowIt = ProjectMeasuresIndexerIterator.create((DbSession)dbSession, (String)projectUuid);){
            BulkIndexer bulkIndexer = this.createBulkIndexer(size, IndexingListener.FAIL_ON_ERROR);
            bulkIndexer.start();
            while (rowIt.hasNext()) {
                ProjectMeasuresIndexerIterator.ProjectMeasures doc = (ProjectMeasuresIndexerIterator.ProjectMeasures)rowIt.next();
                bulkIndexer.add(ProjectMeasuresIndexer.newIndexRequest(ProjectMeasuresIndexer.toProjectMeasuresDoc(doc)));
            }
            bulkIndexer.stop();
        }
    }

    private BulkIndexer createBulkIndexer(BulkIndexer.Size bulkSize, IndexingListener listener) {
        return new BulkIndexer(this.esClient, ProjectMeasuresIndexDefinition.INDEX_TYPE_PROJECT_MEASURES, bulkSize, listener);
    }

    private static IndexRequest newIndexRequest(ProjectMeasuresDoc doc) {
        String projectUuid = doc.getId();
        return new IndexRequest(ProjectMeasuresIndexDefinition.INDEX_TYPE_PROJECT_MEASURES.getIndex(), ProjectMeasuresIndexDefinition.INDEX_TYPE_PROJECT_MEASURES.getType(), projectUuid).routing(projectUuid).parent(projectUuid).source(doc.getFields());
    }

    private static ProjectMeasuresDoc toProjectMeasuresDoc(ProjectMeasuresIndexerIterator.ProjectMeasures projectMeasures) {
        ProjectMeasuresIndexerIterator.Project project = projectMeasures.getProject();
        Long analysisDate = project.getAnalysisDate();
        return new ProjectMeasuresDoc().setId(project.getUuid()).setOrganizationUuid(project.getOrganizationUuid()).setKey(project.getKey()).setName(project.getName()).setQualityGateStatus(projectMeasures.getMeasures().getQualityGateStatus()).setTags(project.getTags()).setAnalysedAt(analysisDate == null ? null : new Date(analysisDate)).setMeasuresFromMap(projectMeasures.getMeasures().getNumericMeasures()).setLanguages(new ArrayList<String>(projectMeasures.getMeasures().getNclocByLanguages().keySet())).setNclocLanguageDistributionFromMap(projectMeasures.getMeasures().getNclocByLanguages());
    }
}

