/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.es;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsResponse;
import org.elasticsearch.action.admin.indices.get.GetIndexResponse;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingResponse;
import org.elasticsearch.cluster.health.ClusterHealthStatus;
import org.elasticsearch.common.settings.Settings;
import org.picocontainer.Startable;
import org.sonar.api.config.Configuration;
import org.sonar.api.server.ServerSide;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.process.ProcessProperties;
import org.sonar.server.es.EsClient;
import org.sonar.server.es.IndexDefinition;
import org.sonar.server.es.IndexDefinitionHash;
import org.sonar.server.es.IndexDefinitions;
import org.sonar.server.es.IndexType;
import org.sonar.server.es.NewIndex;
import org.sonar.server.es.metadata.EsDbCompatibility;
import org.sonar.server.es.metadata.MetadataIndex;
import org.sonar.server.es.metadata.MetadataIndexDefinition;

@ServerSide
public class IndexCreator
implements Startable {
    private static final Logger LOGGER = Loggers.get(IndexCreator.class);
    private final MetadataIndexDefinition metadataIndexDefinition;
    private final MetadataIndex metadataIndex;
    private final EsClient client;
    private final IndexDefinitions definitions;
    private final EsDbCompatibility esDbCompatibility;
    private final Configuration configuration;

    public IndexCreator(EsClient client, IndexDefinitions definitions, MetadataIndexDefinition metadataIndexDefinition, MetadataIndex metadataIndex, EsDbCompatibility esDbCompatibility, Configuration configuration) {
        this.client = client;
        this.definitions = definitions;
        this.metadataIndexDefinition = metadataIndexDefinition;
        this.metadataIndex = metadataIndex;
        this.esDbCompatibility = esDbCompatibility;
        this.configuration = configuration;
    }

    public void start() {
        if (!((IndicesExistsResponse)this.client.prepareIndicesExist(MetadataIndexDefinition.INDEX_TYPE_METADATA.getIndex()).get()).isExists()) {
            IndexDefinition.IndexDefinitionContext context = new IndexDefinition.IndexDefinitionContext();
            this.metadataIndexDefinition.define(context);
            NewIndex newIndex = context.getIndices().values().iterator().next();
            this.createIndex(new IndexDefinitions.Index(newIndex), false);
        }
        this.checkDbCompatibility(this.definitions.getIndices().values());
        for (IndexDefinitions.Index index : this.definitions.getIndices().values()) {
            boolean exists = ((IndicesExistsResponse)this.client.prepareIndicesExist(index.getName()).get()).isExists();
            if (exists && !index.getName().equals(MetadataIndexDefinition.INDEX_TYPE_METADATA.getIndex()) && this.hasDefinitionChange(index)) {
                this.verifyNotBlueGreenDeployment(index.getName());
                LOGGER.info("Delete Elasticsearch index {} (structure changed)", (Object)index.getName());
                this.deleteIndex(index.getName());
                exists = false;
            }
            if (exists) continue;
            this.createIndex(index, true);
        }
    }

    private void verifyNotBlueGreenDeployment(String indexToBeDeleted) {
        if (this.configuration.getBoolean(ProcessProperties.Property.BLUE_GREEN_ENABLED.getKey()).orElse(false).booleanValue()) {
            throw new IllegalStateException("Blue/green deployment is not supported. Elasticsearch index [" + indexToBeDeleted + "] changed and needs to be dropped.");
        }
    }

    public void stop() {
    }

    private void createIndex(IndexDefinitions.Index index, boolean useMetadata) {
        CreateIndexResponse indexResponse;
        LOGGER.info(String.format("Create index %s", index.getName()));
        Settings.Builder settings = Settings.builder();
        settings.put(index.getSettings());
        if (useMetadata) {
            this.metadataIndex.setHash(index.getName(), IndexDefinitionHash.of(index));
            for (IndexDefinitions.IndexType type : index.getTypes().values()) {
                this.metadataIndex.setInitialized(new IndexType(index.getName(), type.getName()), false);
            }
        }
        if (!(indexResponse = (CreateIndexResponse)this.client.prepareCreate(index.getName()).setSettings(settings).get()).isAcknowledged()) {
            throw new IllegalStateException("Failed to create index " + index.getName());
        }
        this.client.waitForStatus(ClusterHealthStatus.YELLOW);
        for (Map.Entry<String, IndexDefinitions.IndexType> entry : index.getTypes().entrySet()) {
            LOGGER.info(String.format("Create type %s/%s", index.getName(), entry.getKey()));
            PutMappingResponse mappingResponse = (PutMappingResponse)this.client.preparePutMapping(index.getName()).setType(entry.getKey()).setSource(entry.getValue().getAttributes()).get();
            if (mappingResponse.isAcknowledged()) continue;
            throw new IllegalStateException("Failed to create type " + entry.getKey());
        }
        this.client.waitForStatus(ClusterHealthStatus.YELLOW);
    }

    private void deleteIndex(String indexName) {
        this.client.nativeClient().admin().indices().prepareDelete(new String[]{indexName}).get();
    }

    private boolean hasDefinitionChange(IndexDefinitions.Index index) {
        return this.metadataIndex.getHash(index.getName()).map(hash -> {
            String defHash = IndexDefinitionHash.of(index);
            return !StringUtils.equals((String)hash, (String)defHash);
        }).orElse(true);
    }

    private void checkDbCompatibility(Collection<IndexDefinitions.Index> definitions) {
        List<String> existingIndices = this.loadExistingIndicesExceptMetadata(definitions);
        if (!existingIndices.isEmpty()) {
            boolean delete = false;
            if (!this.esDbCompatibility.hasSameDbVendor()) {
                LOGGER.info("Delete Elasticsearch indices (DB vendor changed)");
                delete = true;
            }
            if (delete) {
                existingIndices.forEach(this::deleteIndex);
            }
        }
        this.esDbCompatibility.markAsCompatible();
    }

    private List<String> loadExistingIndicesExceptMetadata(Collection<IndexDefinitions.Index> definitions) {
        Set definedNames = definitions.stream().map(IndexDefinitions.Index::getName).collect(Collectors.toSet());
        return Arrays.stream(((GetIndexResponse)this.client.nativeClient().admin().indices().prepareGetIndex().get()).getIndices()).filter(definedNames::contains).filter(index -> !MetadataIndexDefinition.INDEX_TYPE_METADATA.getIndex().equals(index)).collect(Collectors.toList());
    }
}

