/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.duplication.ws;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.sonar.core.util.Protobuf;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDao;
import org.sonar.db.component.ComponentDto;
import org.sonar.server.duplication.ws.DuplicationsParser;
import org.sonarqube.ws.Duplications;

public class ShowResponseBuilder {
    private final ComponentDao componentDao;

    public ShowResponseBuilder(DbClient dbClient) {
        this.componentDao = dbClient.componentDao();
    }

    @VisibleForTesting
    ShowResponseBuilder(ComponentDao componentDao) {
        this.componentDao = componentDao;
    }

    Duplications.ShowResponse build(DbSession session, List<DuplicationsParser.Block> blocks, @Nullable String branch, @Nullable String pullRequest) {
        Duplications.ShowResponse.Builder response = Duplications.ShowResponse.newBuilder();
        HashMap refByComponentKey = Maps.newHashMap();
        blocks.stream().map(block -> ShowResponseBuilder.toWsDuplication(block, refByComponentKey)).forEach(arg_0 -> ((Duplications.ShowResponse.Builder)response).addDuplications(arg_0));
        this.writeFiles(session, response, refByComponentKey, branch, pullRequest);
        return response.build();
    }

    private static Duplications.Duplication.Builder toWsDuplication(DuplicationsParser.Block block, Map<String, String> refByComponentKey) {
        Duplications.Duplication.Builder wsDuplication = Duplications.Duplication.newBuilder();
        block.getDuplications().stream().map(d -> ShowResponseBuilder.toWsBlock(refByComponentKey, d)).forEach(arg_0 -> ((Duplications.Duplication.Builder)wsDuplication).addBlocks(arg_0));
        return wsDuplication;
    }

    private static Duplications.Block.Builder toWsBlock(Map<String, String> refByComponentKey, DuplicationsParser.Duplication duplication) {
        String ref = null;
        ComponentDto componentDto = duplication.file();
        if (componentDto != null) {
            String componentKey = componentDto.getDbKey();
            ref = refByComponentKey.computeIfAbsent(componentKey, k -> Integer.toString(refByComponentKey.size() + 1));
        }
        Duplications.Block.Builder block = Duplications.Block.newBuilder();
        block.setFrom(duplication.from().intValue());
        block.setSize(duplication.size().intValue());
        Protobuf.setNullable((Object)ref, arg_0 -> ((Duplications.Block.Builder)block).setRef(arg_0));
        return block;
    }

    private static Duplications.File toWsFile(ComponentDto file, @Nullable ComponentDto project, @Nullable ComponentDto subProject, @Nullable String branch, @Nullable String pullRequest) {
        Duplications.File.Builder wsFile = Duplications.File.newBuilder();
        wsFile.setKey(file.getKey());
        wsFile.setUuid(file.uuid());
        wsFile.setName(file.longName());
        Protobuf.setNullable((Object)project, p -> {
            boolean displaySubProject;
            wsFile.setProject(p.getKey());
            wsFile.setProjectUuid(p.uuid());
            wsFile.setProjectName(p.longName());
            boolean bl = displaySubProject = subProject != null && !subProject.uuid().equals(project.uuid());
            if (displaySubProject) {
                wsFile.setSubProject(subProject.getKey());
                wsFile.setSubProjectUuid(subProject.uuid());
                wsFile.setSubProjectName(subProject.longName());
            }
            Protobuf.setNullable((Object)branch, arg_0 -> ((Duplications.File.Builder)wsFile).setBranch(arg_0));
            Protobuf.setNullable((Object)pullRequest, arg_0 -> ((Duplications.File.Builder)wsFile).setPullRequest(arg_0));
            return wsFile;
        });
        return wsFile.build();
    }

    private void writeFiles(DbSession session, Duplications.ShowResponse.Builder response, Map<String, String> refByComponentKey, @Nullable String branch, @Nullable String pullRequest) {
        HashMap projectsByUuid = Maps.newHashMap();
        HashMap parentModulesByUuid = Maps.newHashMap();
        Map filesByRef = response.getMutableFiles();
        for (Map.Entry<String, String> entry : refByComponentKey.entrySet()) {
            String componentKey = entry.getKey();
            String ref = entry.getValue();
            Optional fileOptional = this.componentDao.selectByKey(session, componentKey);
            if (!fileOptional.isPresent()) continue;
            ComponentDto file = (ComponentDto)fileOptional.get();
            ComponentDto project = this.getProject(file.projectUuid(), projectsByUuid, session);
            ComponentDto parentModule = this.getParentProject(file.getRootUuid(), parentModulesByUuid, session);
            filesByRef.put(ref, ShowResponseBuilder.toWsFile(file, project, parentModule, branch, pullRequest));
        }
    }

    private ComponentDto getProject(String projectUuid, Map<String, ComponentDto> projectsByUuid, DbSession session) {
        Optional projectOptional;
        ComponentDto project = projectsByUuid.get(projectUuid);
        if (project == null && (projectOptional = this.componentDao.selectByUuid(session, projectUuid)).isPresent()) {
            project = (ComponentDto)projectOptional.get();
            projectsByUuid.put(project.uuid(), project);
        }
        return project;
    }

    private ComponentDto getParentProject(String rootUuid, Map<String, ComponentDto> subProjectsByUuid, DbSession session) {
        Optional projectOptional;
        ComponentDto project = subProjectsByUuid.get(rootUuid);
        if (project == null && (projectOptional = this.componentDao.selectByUuid(session, rootUuid)).isPresent()) {
            project = (ComponentDto)projectOptional.get();
            subProjectsByUuid.put(project.uuid(), project);
        }
        return project;
    }
}

