/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.webhook;

import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.sonar.api.ce.posttask.Analysis;
import org.sonar.api.ce.posttask.PostProjectAnalysisTask;
import org.sonar.api.ce.posttask.QualityGate;
import org.sonar.api.measures.Metric;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.server.project.Project;
import org.sonar.server.qualitygate.Condition;
import org.sonar.server.qualitygate.EvaluatedCondition;
import org.sonar.server.qualitygate.EvaluatedQualityGate;
import org.sonar.server.qualitygate.QualityGate;
import org.sonar.server.webhook.Branch;
import org.sonar.server.webhook.CeTask;
import org.sonar.server.webhook.ProjectAnalysis;
import org.sonar.server.webhook.WebHooks;
import org.sonar.server.webhook.WebhookPayloadFactory;

public class WebhookPostTask
implements PostProjectAnalysisTask {
    private final WebhookPayloadFactory payloadFactory;
    private final WebHooks webHooks;

    public WebhookPostTask(WebhookPayloadFactory payloadFactory, WebHooks webHooks) {
        this.payloadFactory = payloadFactory;
        this.webHooks = webHooks;
    }

    public void finished(PostProjectAnalysisTask.ProjectAnalysis analysis) {
        this.webHooks.sendProjectAnalysisUpdate(new WebHooks.Analysis(analysis.getProject().getUuid(), analysis.getAnalysis().map(Analysis::getAnalysisUuid).orElse(null), analysis.getCeTask().getId()), () -> this.payloadFactory.create(WebhookPostTask.convert(analysis)));
    }

    private static ProjectAnalysis convert(PostProjectAnalysisTask.ProjectAnalysis projectAnalysis) {
        CeTask ceTask = new CeTask(projectAnalysis.getCeTask().getId(), CeTask.Status.valueOf(projectAnalysis.getCeTask().getStatus().name()));
        Project project = new Project(projectAnalysis.getProject().getUuid(), projectAnalysis.getProject().getKey(), projectAnalysis.getProject().getName());
        org.sonar.server.webhook.Analysis analysis = projectAnalysis.getAnalysis().map(a -> new org.sonar.server.webhook.Analysis(a.getAnalysisUuid(), a.getDate().getTime())).orElse(null);
        Branch branch = projectAnalysis.getBranch().map(b -> new Branch(b.isMain(), b.getName().orElse(null), Branch.Type.valueOf(b.getType().name()))).orElse(null);
        EvaluatedQualityGate qualityGate = Optional.ofNullable(projectAnalysis.getQualityGate()).map(qg -> {
            EvaluatedQualityGate.Builder builder = EvaluatedQualityGate.newBuilder();
            Set conditions = (Set)qg.getConditions().stream().map(q -> {
                Condition condition = new Condition(q.getMetricKey(), Condition.Operator.valueOf(q.getOperator().name()), q.getErrorThreshold(), q.getWarningThreshold(), q.isOnLeakPeriod());
                builder.addCondition(condition, EvaluatedCondition.EvaluationStatus.valueOf(q.getStatus().name()), q.getStatus() == QualityGate.EvaluationStatus.NO_VALUE ? null : q.getValue());
                return condition;
            }).collect(MoreCollectors.toSet());
            return builder.setQualityGate(new QualityGate(qg.getId(), qg.getName(), conditions)).setStatus(Metric.Level.valueOf((String)qg.getStatus().name())).build();
        }).orElse(null);
        Long date = projectAnalysis.getAnalysis().map(a -> a.getDate().getTime()).orElse(null);
        Map properties = projectAnalysis.getScannerContext().getProperties();
        return new ProjectAnalysis(project, ceTask, analysis, branch, qualityGate, date, properties);
    }
}

