/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.step;

import com.google.common.base.Optional;
import javax.annotation.Nullable;
import org.sonar.api.notifications.Notification;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.server.computation.task.projectanalysis.analysis.AnalysisMetadataHolder;
import org.sonar.server.computation.task.projectanalysis.analysis.Branch;
import org.sonar.server.computation.task.projectanalysis.component.Component;
import org.sonar.server.computation.task.projectanalysis.component.ComponentVisitor;
import org.sonar.server.computation.task.projectanalysis.component.CrawlerDepthLimit;
import org.sonar.server.computation.task.projectanalysis.component.DepthTraversalTypeAwareCrawler;
import org.sonar.server.computation.task.projectanalysis.component.TreeRootHolder;
import org.sonar.server.computation.task.projectanalysis.component.TypeAwareVisitorAdapter;
import org.sonar.server.computation.task.projectanalysis.event.Event;
import org.sonar.server.computation.task.projectanalysis.event.EventRepository;
import org.sonar.server.computation.task.projectanalysis.measure.Measure;
import org.sonar.server.computation.task.projectanalysis.measure.MeasureRepository;
import org.sonar.server.computation.task.projectanalysis.measure.QualityGateStatus;
import org.sonar.server.computation.task.projectanalysis.metric.Metric;
import org.sonar.server.computation.task.projectanalysis.metric.MetricRepository;
import org.sonar.server.computation.task.step.ComputationStep;
import org.sonar.server.notification.NotificationService;

public class QualityGateEventsStep
implements ComputationStep {
    private static final Logger LOGGER = Loggers.get(QualityGateEventsStep.class);
    private final TreeRootHolder treeRootHolder;
    private final MetricRepository metricRepository;
    private final MeasureRepository measureRepository;
    private final EventRepository eventRepository;
    private final NotificationService notificationService;
    private final AnalysisMetadataHolder analysisMetadataHolder;

    public QualityGateEventsStep(TreeRootHolder treeRootHolder, MetricRepository metricRepository, MeasureRepository measureRepository, EventRepository eventRepository, NotificationService notificationService, AnalysisMetadataHolder analysisMetadataHolder) {
        this.treeRootHolder = treeRootHolder;
        this.metricRepository = metricRepository;
        this.measureRepository = measureRepository;
        this.eventRepository = eventRepository;
        this.notificationService = notificationService;
        this.analysisMetadataHolder = analysisMetadataHolder;
    }

    @Override
    public void execute() {
        if (this.analysisMetadataHolder.isShortLivingBranch() || this.analysisMetadataHolder.isPullRequest()) {
            return;
        }
        new DepthTraversalTypeAwareCrawler(new TypeAwareVisitorAdapter(CrawlerDepthLimit.PROJECT, ComponentVisitor.Order.PRE_ORDER){

            @Override
            public void visitProject(Component project) {
                QualityGateEventsStep.this.executeForProject(project);
            }
        }).visit(this.treeRootHolder.getRoot());
    }

    private void executeForProject(Component project) {
        Metric metric = this.metricRepository.getByKey("alert_status");
        Optional<Measure> rawStatus = this.measureRepository.getRawMeasure(project, metric);
        if (!rawStatus.isPresent() || !((Measure)rawStatus.get()).hasQualityGateStatus()) {
            return;
        }
        this.checkQualityGateStatusChange(project, metric, ((Measure)rawStatus.get()).getQualityGateStatus());
    }

    private void checkQualityGateStatusChange(Component project, Metric metric, QualityGateStatus rawStatus) {
        Optional<Measure> baseMeasure = this.measureRepository.getBaseMeasure(project, metric);
        if (!baseMeasure.isPresent()) {
            this.checkNewQualityGate(project, rawStatus);
            return;
        }
        if (!((Measure)baseMeasure.get()).hasQualityGateStatus()) {
            LOGGER.warn(String.format("Previous Quality gate status for project %s is not a supported value. Can not compute Quality Gate event", project.getKey()));
            this.checkNewQualityGate(project, rawStatus);
            return;
        }
        QualityGateStatus baseStatus = ((Measure)baseMeasure.get()).getQualityGateStatus();
        if (baseStatus.getStatus() != rawStatus.getStatus()) {
            String label = String.format("%s (was %s)", rawStatus.getStatus().getColorName(), baseStatus.getStatus().getColorName());
            this.createEvent(project, label, rawStatus.getText());
            boolean isNewKo = rawStatus.getStatus() == Measure.Level.OK;
            this.notifyUsers(project, label, rawStatus, isNewKo);
        }
    }

    private void checkNewQualityGate(Component project, QualityGateStatus rawStatus) {
        if (rawStatus.getStatus() != Measure.Level.OK) {
            this.createEvent(project, rawStatus.getStatus().getColorName(), rawStatus.getText());
            this.notifyUsers(project, rawStatus.getStatus().getColorName(), rawStatus, true);
        }
    }

    private void notifyUsers(Component project, String label, QualityGateStatus rawStatus, boolean isNewAlert) {
        Notification notification = new Notification("alerts").setDefaultMessage(String.format("Alert on %s: %s", project.getName(), label)).setFieldValue("projectName", project.getName()).setFieldValue("projectKey", project.getPublicKey()).setFieldValue("projectVersion", project.getReportAttributes().getVersion()).setFieldValue("alertName", label).setFieldValue("alertText", rawStatus.getText()).setFieldValue("alertLevel", rawStatus.getStatus().toString()).setFieldValue("isNewAlert", Boolean.toString(isNewAlert));
        Branch branch = this.analysisMetadataHolder.getBranch();
        if (!branch.isMain()) {
            notification.setFieldValue("branch", branch.getName());
        }
        this.notificationService.deliver(notification);
    }

    private void createEvent(Component project, String name, @Nullable String description) {
        this.eventRepository.add(project, Event.createAlert(name, null, description));
    }

    @Override
    public String getDescription() {
        return "Generate Quality gate events";
    }
}

