/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.step;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.SetMultimap;
import java.util.Collection;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.measure.MeasureDao;
import org.sonar.db.measure.MeasureDto;
import org.sonar.server.computation.task.projectanalysis.component.Component;
import org.sonar.server.computation.task.projectanalysis.component.ComponentVisitor;
import org.sonar.server.computation.task.projectanalysis.component.ConfigurationRepository;
import org.sonar.server.computation.task.projectanalysis.component.CrawlerDepthLimit;
import org.sonar.server.computation.task.projectanalysis.component.DepthTraversalTypeAwareCrawler;
import org.sonar.server.computation.task.projectanalysis.component.TreeRootHolder;
import org.sonar.server.computation.task.projectanalysis.component.TypeAwareVisitorAdapter;
import org.sonar.server.computation.task.projectanalysis.measure.Measure;
import org.sonar.server.computation.task.projectanalysis.measure.MeasureRepository;
import org.sonar.server.computation.task.projectanalysis.measure.MeasureToMeasureDto;
import org.sonar.server.computation.task.projectanalysis.metric.Metric;
import org.sonar.server.computation.task.projectanalysis.metric.MetricRepository;
import org.sonar.server.computation.task.step.ComputationStep;

public class PersistMeasuresStep
implements ComputationStep {
    private final DbClient dbClient;
    private final MetricRepository metricRepository;
    private final MeasureToMeasureDto measureToMeasureDto;
    private final TreeRootHolder treeRootHolder;
    private final MeasureRepository measureRepository;
    private final boolean persistDirectories;

    public PersistMeasuresStep(DbClient dbClient, MetricRepository metricRepository, MeasureToMeasureDto measureToMeasureDto, TreeRootHolder treeRootHolder, MeasureRepository measureRepository, ConfigurationRepository settings) {
        this(dbClient, metricRepository, measureToMeasureDto, treeRootHolder, measureRepository, (Boolean)settings.getConfiguration().getBoolean("sonar.dbcleaner.cleanDirectory").orElseThrow(() -> new IllegalStateException("Missing default value")) == false);
    }

    @VisibleForTesting
    PersistMeasuresStep(DbClient dbClient, MetricRepository metricRepository, MeasureToMeasureDto measureToMeasureDto, TreeRootHolder treeRootHolder, MeasureRepository measureRepository, boolean persistDirectories) {
        this.dbClient = dbClient;
        this.metricRepository = metricRepository;
        this.measureToMeasureDto = measureToMeasureDto;
        this.treeRootHolder = treeRootHolder;
        this.measureRepository = measureRepository;
        this.persistDirectories = persistDirectories;
    }

    @Override
    public String getDescription() {
        return "Persist measures";
    }

    @Override
    public void execute() {
        try (DbSession dbSession = this.dbClient.openSession(true);){
            new DepthTraversalTypeAwareCrawler(new MeasureVisitor(dbSession)).visit(this.treeRootHolder.getRoot());
            dbSession.commit();
        }
    }

    private static enum NonEmptyMeasure implements Predicate<Measure>
    {
        INSTANCE;


        @Override
        public boolean test(@Nonnull Measure input) {
            return input.getValueType() != Measure.ValueType.NO_VALUE || input.hasVariation() || input.getData() != null;
        }
    }

    private class MeasureVisitor
    extends TypeAwareVisitorAdapter {
        private final DbSession session;

        private MeasureVisitor(DbSession session) {
            super(CrawlerDepthLimit.LEAVES, ComponentVisitor.Order.PRE_ORDER);
            this.session = session;
        }

        @Override
        public void visitProject(Component project) {
            this.persistMeasures(project);
        }

        @Override
        public void visitModule(Component module) {
            this.persistMeasures(module);
        }

        @Override
        public void visitDirectory(Component directory) {
            if (PersistMeasuresStep.this.persistDirectories) {
                this.persistMeasures(directory);
            }
        }

        @Override
        public void visitView(Component view) {
            this.persistMeasures(view);
        }

        @Override
        public void visitSubView(Component subView) {
            this.persistMeasures(subView);
        }

        @Override
        public void visitProjectView(Component projectView) {
        }

        private void persistMeasures(Component component) {
            SetMultimap<String, Measure> measures = PersistMeasuresStep.this.measureRepository.getRawMeasures(component);
            for (Map.Entry measuresByMetricKey : measures.asMap().entrySet()) {
                String metricKey = (String)measuresByMetricKey.getKey();
                Metric metric = PersistMeasuresStep.this.metricRepository.getByKey(metricKey);
                MeasureDao measureDao = PersistMeasuresStep.this.dbClient.measureDao();
                ((Collection)measuresByMetricKey.getValue()).stream().filter(NonEmptyMeasure.INSTANCE).forEach(measure -> {
                    MeasureDto measureDto = PersistMeasuresStep.this.measureToMeasureDto.toMeasureDto((Measure)measure, metric, component);
                    measureDao.insert(this.session, measureDto);
                });
            }
        }
    }
}

