/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.step;

import com.google.common.collect.SetMultimap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import org.sonar.core.util.Uuids;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.measure.LiveMeasureDao;
import org.sonar.db.measure.LiveMeasureDto;
import org.sonar.server.computation.task.projectanalysis.component.Component;
import org.sonar.server.computation.task.projectanalysis.component.ComponentVisitor;
import org.sonar.server.computation.task.projectanalysis.component.CrawlerDepthLimit;
import org.sonar.server.computation.task.projectanalysis.component.DepthTraversalTypeAwareCrawler;
import org.sonar.server.computation.task.projectanalysis.component.TreeRootHolder;
import org.sonar.server.computation.task.projectanalysis.component.TypeAwareVisitorAdapter;
import org.sonar.server.computation.task.projectanalysis.measure.BestValueOptimization;
import org.sonar.server.computation.task.projectanalysis.measure.Measure;
import org.sonar.server.computation.task.projectanalysis.measure.MeasureRepository;
import org.sonar.server.computation.task.projectanalysis.measure.MeasureToMeasureDto;
import org.sonar.server.computation.task.projectanalysis.metric.Metric;
import org.sonar.server.computation.task.projectanalysis.metric.MetricRepository;
import org.sonar.server.computation.task.step.ComputationStep;

public class PersistLiveMeasuresStep
implements ComputationStep {
    private static final Set<String> NOT_TO_PERSIST_ON_FILE_METRIC_KEYS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("file_complexity_distribution", "function_complexity_distribution", "class_complexity_distribution")));
    private final DbClient dbClient;
    private final MetricRepository metricRepository;
    private final MeasureToMeasureDto measureToMeasureDto;
    private final TreeRootHolder treeRootHolder;
    private final MeasureRepository measureRepository;

    public PersistLiveMeasuresStep(DbClient dbClient, MetricRepository metricRepository, MeasureToMeasureDto measureToMeasureDto, TreeRootHolder treeRootHolder, MeasureRepository measureRepository) {
        this.dbClient = dbClient;
        this.metricRepository = metricRepository;
        this.measureToMeasureDto = measureToMeasureDto;
        this.treeRootHolder = treeRootHolder;
        this.measureRepository = measureRepository;
    }

    @Override
    public String getDescription() {
        return "Persist live measures";
    }

    @Override
    public void execute() {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            String marker = Uuids.create();
            Component root = this.treeRootHolder.getRoot();
            new DepthTraversalTypeAwareCrawler(new MeasureVisitor(dbSession, marker)).visit(root);
            this.dbClient.liveMeasureDao().deleteByProjectUuidExcludingMarker(dbSession, root.getUuid(), marker);
            dbSession.commit();
        }
    }

    private static enum NonEmptyMeasure implements Predicate<Measure>
    {
        INSTANCE;


        @Override
        public boolean test(@Nonnull Measure input) {
            return input.getValueType() != Measure.ValueType.NO_VALUE || input.hasVariation() || input.getData() != null;
        }
    }

    private class MeasureVisitor
    extends TypeAwareVisitorAdapter {
        private final DbSession dbSession;
        private final String marker;

        private MeasureVisitor(DbSession dbSession, String marker) {
            super(CrawlerDepthLimit.LEAVES, ComponentVisitor.Order.PRE_ORDER);
            this.dbSession = dbSession;
            this.marker = marker;
        }

        @Override
        public void visitAny(Component component) {
            int count = 0;
            LiveMeasureDao dao = PersistLiveMeasuresStep.this.dbClient.liveMeasureDao();
            SetMultimap<String, Measure> measures = PersistLiveMeasuresStep.this.measureRepository.getRawMeasures(component);
            for (Map.Entry measuresByMetricKey : measures.asMap().entrySet()) {
                String metricKey = (String)measuresByMetricKey.getKey();
                if (NOT_TO_PERSIST_ON_FILE_METRIC_KEYS.contains(metricKey) && component.getType() == Component.Type.FILE) continue;
                Metric metric = PersistLiveMeasuresStep.this.metricRepository.getByKey(metricKey);
                Predicate<Measure> notBestValueOptimized = BestValueOptimization.from(metric, component).negate();
                Iterator liveMeasures = ((Collection)measuresByMetricKey.getValue()).stream().filter(NonEmptyMeasure.INSTANCE).filter(notBestValueOptimized).map(measure -> PersistLiveMeasuresStep.this.measureToMeasureDto.toLiveMeasureDto((Measure)measure, metric, component)).iterator();
                while (liveMeasures.hasNext()) {
                    dao.insertOrUpdate(this.dbSession, (LiveMeasureDto)liveMeasures.next(), this.marker);
                    if (++count % 100 != 0) continue;
                    this.dbSession.commit();
                }
            }
        }
    }
}

