/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.step;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.utils.MessageException;
import org.sonar.ce.queue.CeTask;
import org.sonar.core.component.ComponentKeys;
import org.sonar.core.platform.PluginRepository;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.qualityprofile.QProfileDto;
import org.sonar.scanner.protocol.output.ScannerReport;
import org.sonar.server.computation.task.projectanalysis.analysis.MutableAnalysisMetadataHolder;
import org.sonar.server.computation.task.projectanalysis.analysis.Organization;
import org.sonar.server.computation.task.projectanalysis.analysis.ScannerPlugin;
import org.sonar.server.computation.task.projectanalysis.batch.BatchReportReader;
import org.sonar.server.computation.task.projectanalysis.component.BranchLoader;
import org.sonar.server.computation.task.step.ComputationStep;
import org.sonar.server.organization.DefaultOrganizationProvider;
import org.sonar.server.organization.OrganizationFlags;
import org.sonar.server.project.Project;
import org.sonar.server.qualityprofile.QualityProfile;

public class LoadReportAnalysisMetadataHolderStep
implements ComputationStep {
    private final CeTask ceTask;
    private final BatchReportReader reportReader;
    private final MutableAnalysisMetadataHolder analysisMetadata;
    private final DefaultOrganizationProvider defaultOrganizationProvider;
    private final DbClient dbClient;
    private final BranchLoader branchLoader;
    private final PluginRepository pluginRepository;
    private final OrganizationFlags organizationFlags;

    public LoadReportAnalysisMetadataHolderStep(CeTask ceTask, BatchReportReader reportReader, MutableAnalysisMetadataHolder analysisMetadata, DefaultOrganizationProvider defaultOrganizationProvider, DbClient dbClient, BranchLoader branchLoader, PluginRepository pluginRepository, OrganizationFlags organizationFlags) {
        this.ceTask = ceTask;
        this.reportReader = reportReader;
        this.analysisMetadata = analysisMetadata;
        this.defaultOrganizationProvider = defaultOrganizationProvider;
        this.dbClient = dbClient;
        this.branchLoader = branchLoader;
        this.pluginRepository = pluginRepository;
        this.organizationFlags = organizationFlags;
    }

    @Override
    public void execute() {
        ScannerReport.Metadata reportMetadata = this.reportReader.readMetadata();
        this.loadMetadata(reportMetadata);
        Organization organization = this.loadOrganization(reportMetadata);
        Runnable projectValidation = this.loadProject(reportMetadata, organization);
        this.loadQualityProfiles(reportMetadata, organization);
        this.branchLoader.load(reportMetadata);
        projectValidation.run();
    }

    private void loadMetadata(ScannerReport.Metadata reportMetadata) {
        this.analysisMetadata.setAnalysisDate(reportMetadata.getAnalysisDate());
        this.analysisMetadata.setRootComponentRef(reportMetadata.getRootComponentRef());
        this.analysisMetadata.setCrossProjectDuplicationEnabled(reportMetadata.getCrossProjectDuplicationActivated());
    }

    private Runnable loadProject(ScannerReport.Metadata reportMetadata, Organization organization) {
        String reportProjectKey = LoadReportAnalysisMetadataHolderStep.projectKeyFromReport(reportMetadata);
        String componentKey = this.ceTask.getComponentKey();
        if (componentKey == null) {
            throw MessageException.of((String)String.format("Compute Engine task component key is null. Project with UUID %s must have been deleted since report was uploaded. Can not proceed.", this.ceTask.getComponentUuid()));
        }
        ComponentDto dto = this.toProject(reportProjectKey);
        this.analysisMetadata.setProject(new Project(dto.uuid(), dto.getDbKey(), dto.name(), dto.description()));
        return () -> {
            if (!componentKey.equals(reportProjectKey)) {
                throw MessageException.of((String)String.format("ProjectKey in report (%s) is not consistent with projectKey under which the report has been submitted (%s)", reportProjectKey, componentKey));
            }
            if (!dto.getOrganizationUuid().equals(organization.getUuid())) {
                throw MessageException.of((String)String.format("Project is not in the expected organization: %s", organization.getKey()));
            }
            if (dto.getMainBranchProjectUuid() != null) {
                throw MessageException.of((String)"Project should not reference a branch");
            }
        };
    }

    private Organization loadOrganization(ScannerReport.Metadata reportMetadata) {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            Organization organization = this.toOrganization(dbSession, this.ceTask.getOrganizationUuid());
            this.checkOrganizationKeyConsistency(reportMetadata, organization);
            this.analysisMetadata.setOrganization(organization);
            this.analysisMetadata.setOrganizationsEnabled(this.organizationFlags.isEnabled(dbSession));
            Organization organization2 = organization;
            return organization2;
        }
    }

    private void loadQualityProfiles(ScannerReport.Metadata reportMetadata, Organization organization) {
        this.checkQualityProfilesConsistency(reportMetadata, organization);
        this.analysisMetadata.setQProfilesByLanguage(reportMetadata.getQprofilesPerLanguage().values().stream().collect(Collectors.toMap(ScannerReport.Metadata.QProfile::getLanguage, qp -> new QualityProfile(qp.getKey(), qp.getName(), qp.getLanguage(), new Date(qp.getRulesUpdatedAt())))));
        this.analysisMetadata.setScannerPluginsByKey(reportMetadata.getPluginsByKey().values().stream().collect(Collectors.toMap(ScannerReport.Metadata.Plugin::getKey, p -> new ScannerPlugin(p.getKey(), this.getBasePluginKey((ScannerReport.Metadata.Plugin)p), p.getUpdatedAt()))));
    }

    @CheckForNull
    private String getBasePluginKey(ScannerReport.Metadata.Plugin p) {
        if (!this.pluginRepository.hasPlugin(p.getKey())) {
            return null;
        }
        return this.pluginRepository.getPluginInfo(p.getKey()).getBasePlugin();
    }

    private void checkQualityProfilesConsistency(ScannerReport.Metadata metadata, Organization organization) {
        List profileKeys = (List)metadata.getQprofilesPerLanguage().values().stream().map(ScannerReport.Metadata.QProfile::getKey).collect(MoreCollectors.toList((int)metadata.getQprofilesPerLanguage().size()));
        try (DbSession dbSession = this.dbClient.openSession(false);){
            List profiles = this.dbClient.qualityProfileDao().selectByUuids(dbSession, profileKeys);
            String badKeys = (String)profiles.stream().filter(p -> !p.getOrganizationUuid().equals(organization.getUuid())).map(QProfileDto::getKee).collect(MoreCollectors.join((Joiner)Joiner.on((String)", ")));
            if (!badKeys.isEmpty()) {
                throw MessageException.of((String)String.format("Quality profiles with following keys don't exist in organization [%s]: %s", organization.getKey(), badKeys));
            }
        }
    }

    private void checkOrganizationKeyConsistency(ScannerReport.Metadata reportMetadata, Organization organization) {
        String organizationKey = reportMetadata.getOrganizationKey();
        String resolveReportOrganizationKey = this.resolveReportOrganizationKey(organizationKey);
        if (!resolveReportOrganizationKey.equals(organization.getKey())) {
            if (LoadReportAnalysisMetadataHolderStep.reportBelongsToDefaultOrganization(organizationKey)) {
                throw MessageException.of((String)String.format("Report does not specify an OrganizationKey but it has been submitted to another organization (%s) than the default one (%s)", organization.getKey(), this.defaultOrganizationProvider.get().getKey()));
            }
            throw MessageException.of((String)String.format("OrganizationKey in report (%s) is not consistent with organizationKey under which the report as been submitted (%s)", resolveReportOrganizationKey, organization.getKey()));
        }
    }

    private String resolveReportOrganizationKey(@Nullable String organizationKey) {
        if (LoadReportAnalysisMetadataHolderStep.reportBelongsToDefaultOrganization(organizationKey)) {
            return this.defaultOrganizationProvider.get().getKey();
        }
        return organizationKey;
    }

    private static boolean reportBelongsToDefaultOrganization(@Nullable String organizationKey) {
        return organizationKey == null || organizationKey.isEmpty();
    }

    private Organization toOrganization(DbSession dbSession, String organizationUuid) {
        Optional organizationDto = this.dbClient.organizationDao().selectByUuid(dbSession, organizationUuid);
        Preconditions.checkState((boolean)organizationDto.isPresent(), (String)"Organization with uuid '%s' can't be found", (Object[])new Object[]{organizationUuid});
        return Organization.from((OrganizationDto)organizationDto.get());
    }

    private ComponentDto toProject(String projectKey) {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            com.google.common.base.Optional opt = this.dbClient.componentDao().selectByKey(dbSession, projectKey);
            Preconditions.checkState((boolean)opt.isPresent(), (String)"Project with key '%s' can't be found", (Object[])new Object[]{projectKey});
            ComponentDto componentDto = (ComponentDto)opt.get();
            return componentDto;
        }
    }

    private static String projectKeyFromReport(ScannerReport.Metadata reportMetadata) {
        String deprecatedBranch = reportMetadata.getDeprecatedBranch();
        if (StringUtils.isNotEmpty((String)deprecatedBranch)) {
            return ComponentKeys.createKey((String)reportMetadata.getProjectKey(), (String)deprecatedBranch);
        }
        return reportMetadata.getProjectKey();
    }

    @Override
    public String getDescription() {
        return "Load analysis metadata";
    }
}

