/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.qualitymodel;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.sonar.api.ce.ComputeEngineSide;
import org.sonar.api.config.Configuration;
import org.sonar.api.utils.MessageException;
import org.sonar.server.computation.task.projectanalysis.qualitymodel.DebtRatingGrid;

@ComputeEngineSide
public class RatingSettings {
    private final DebtRatingGrid ratingGrid;
    private final long defaultDevCost;
    private final Map<String, LanguageSpecificConfiguration> languageSpecificConfigurationByLanguageKey;

    public RatingSettings(Configuration config) {
        this.ratingGrid = new DebtRatingGrid(config);
        this.defaultDevCost = RatingSettings.initDefaultDevelopmentCost(config);
        this.languageSpecificConfigurationByLanguageKey = RatingSettings.initLanguageSpecificConfigurationByLanguageKey(config);
    }

    public DebtRatingGrid getDebtRatingGrid() {
        return this.ratingGrid;
    }

    public long getDevCost(@Nullable String languageKey) {
        if (languageKey != null) {
            try {
                LanguageSpecificConfiguration languageSpecificConfig = this.getSpecificParametersForLanguage(languageKey);
                if (languageSpecificConfig != null && languageSpecificConfig.getManDays() != null) {
                    return Long.parseLong(languageSpecificConfig.getManDays());
                }
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(String.format("The manDays for language %s is not a valid long number", languageKey), e);
            }
        }
        return this.defaultDevCost;
    }

    @CheckForNull
    private LanguageSpecificConfiguration getSpecificParametersForLanguage(String languageKey) {
        return this.languageSpecificConfigurationByLanguageKey.get(languageKey);
    }

    private static Map<String, LanguageSpecificConfiguration> initLanguageSpecificConfigurationByLanguageKey(Configuration config) {
        String[] languageConfigIndexes;
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (String languageConfigIndex : languageConfigIndexes = config.getStringArray("languageSpecificParameters")) {
            String languagePropertyKey = "languageSpecificParameters." + languageConfigIndex + "." + "language";
            String languageKey = (String)config.get(languagePropertyKey).orElseThrow(() -> MessageException.of((String)"Technical debt configuration is corrupted. At least one language specific parameter has no Language key. Contact your administrator to update this configuration in the global administration section of SonarQube."));
            builder.put((Object)languageKey, (Object)LanguageSpecificConfiguration.create(config, languageConfigIndex));
        }
        return builder.build();
    }

    private static long initDefaultDevelopmentCost(Configuration config) {
        try {
            return Long.parseLong((String)config.get("sonar.technicalDebt.developmentCost").get());
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("The value of the development cost property 'sonar.technicalDebt.developmentCost' is incorrect. Expected long but got '" + (String)config.get("sonar.technicalDebt.developmentCost").get() + "'", e);
        }
    }

    @Immutable
    private static class LanguageSpecificConfiguration {
        private final String language;
        private final String manDays;
        private final String metricKey;

        private LanguageSpecificConfiguration(String language, String manDays, String metricKey) {
            this.language = language;
            this.manDays = manDays;
            this.metricKey = metricKey;
        }

        static LanguageSpecificConfiguration create(Configuration config, String configurationId) {
            String configurationPrefix = "languageSpecificParameters." + configurationId + ".";
            String language = config.get(configurationPrefix + "language").orElse(null);
            String manDays = config.get(configurationPrefix + "man_days").orElse(null);
            String metric = config.get(configurationPrefix + "size_metric").orElse(null);
            return new LanguageSpecificConfiguration(language, manDays, metric);
        }

        String getLanguage() {
            return this.language;
        }

        String getManDays() {
            return this.manDays;
        }

        String getMetricKey() {
            return this.metricKey;
        }
    }
}

