/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.issue;

import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import javax.annotation.CheckForNull;
import org.sonar.api.server.debt.DebtRemediationFunction;
import org.sonar.api.utils.Duration;
import org.sonar.api.utils.Durations;
import org.sonar.core.issue.DefaultIssue;
import org.sonar.server.computation.task.projectanalysis.issue.Rule;
import org.sonar.server.computation.task.projectanalysis.issue.RuleRepository;

public class DebtCalculator {
    private final RuleRepository ruleRepository;
    private final Durations durations;

    public DebtCalculator(RuleRepository ruleRepository, Durations durations) {
        this.ruleRepository = ruleRepository;
        this.durations = durations;
    }

    @CheckForNull
    public Duration calculate(DefaultIssue issue) {
        if (issue.isFromExternalRuleEngine()) {
            return issue.effort();
        }
        Rule rule = this.ruleRepository.getByKey(issue.ruleKey());
        DebtRemediationFunction fn = rule.getRemediationFunction();
        if (fn != null) {
            DebtCalculator.verifyEffortToFix(issue, fn);
            Duration debt = Duration.create((long)0L);
            String gapMultiplier = fn.gapMultiplier();
            if (fn.type().usesGapMultiplier() && !Strings.isNullOrEmpty((String)gapMultiplier)) {
                int effortToFixValue = ((Number)MoreObjects.firstNonNull((Object)issue.gap(), (Object)1)).intValue();
                debt = this.durations.decode(gapMultiplier).multiply(effortToFixValue);
            }
            String baseEffort = fn.baseEffort();
            if (fn.type().usesBaseEffort() && !Strings.isNullOrEmpty((String)baseEffort)) {
                debt = debt.add(this.durations.decode(baseEffort));
            }
            return debt;
        }
        return null;
    }

    private static void verifyEffortToFix(DefaultIssue issue, DebtRemediationFunction fn) {
        if (DebtRemediationFunction.Type.CONSTANT_ISSUE.equals((Object)fn.type()) && issue.gap() != null) {
            throw new IllegalArgumentException("Rule '" + issue.getRuleKey() + "' can not use 'Constant/issue' remediation function because this rule does not have a fixed remediation cost.");
        }
    }
}

