/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.component;

import com.google.common.base.Preconditions;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class FileAttributes {
    private final boolean unitTest;
    @CheckForNull
    private final String languageKey;
    private final int lines;

    public FileAttributes(boolean unitTest, @Nullable String languageKey, int lines) {
        this.unitTest = unitTest;
        this.languageKey = languageKey;
        Preconditions.checkArgument((lines > 0 ? 1 : 0) != 0, (Object)"Number of lines must be greater than zero");
        this.lines = lines;
    }

    public boolean isUnitTest() {
        return this.unitTest;
    }

    @CheckForNull
    public String getLanguageKey() {
        return this.languageKey;
    }

    public int getLines() {
        return this.lines;
    }

    public String toString() {
        return "FileAttributes{languageKey='" + this.languageKey + '\'' + ", unitTest=" + this.unitTest + ", lines=" + this.lines + '}';
    }
}

