/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sonar.core.util.Uuids;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.KeyWithUuidDto;

public class ComponentUuidFactory {
    private final Map<String, String> uuidsByKey = new HashMap<String, String>();

    public ComponentUuidFactory(DbClient dbClient, DbSession dbSession, String rootKey) {
        List keys = dbClient.componentDao().selectUuidsByKeyFromProjectKey(dbSession, rootKey);
        for (KeyWithUuidDto dto : keys) {
            this.uuidsByKey.put(dto.key(), dto.uuid());
        }
    }

    public String getOrCreateForKey(String key) {
        return this.uuidsByKey.computeIfAbsent(key, k -> Uuids.create());
    }
}

