/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.authentication;

import java.io.IOException;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.sonar.api.platform.Server;
import org.sonar.api.server.ServerSide;
import org.sonar.api.server.authentication.IdentityProvider;
import org.sonar.api.server.authentication.OAuth2IdentityProvider;
import org.sonar.api.server.authentication.UserIdentity;
import org.sonar.db.user.UserDto;
import org.sonar.server.authentication.JwtHttpHandler;
import org.sonar.server.authentication.OAuth2AuthenticationParameters;
import org.sonar.server.authentication.OAuthCsrfVerifier;
import org.sonar.server.authentication.UserIdentityAuthenticator;
import org.sonar.server.authentication.UserIdentityAuthenticatorParameters;
import org.sonar.server.authentication.event.AuthenticationEvent;
import org.sonar.server.user.ThreadLocalUserSession;
import org.sonar.server.user.UserSessionFactory;

@ServerSide
public class OAuth2ContextFactory {
    private final ThreadLocalUserSession threadLocalUserSession;
    private final UserIdentityAuthenticator userIdentityAuthenticator;
    private final Server server;
    private final OAuthCsrfVerifier csrfVerifier;
    private final JwtHttpHandler jwtHttpHandler;
    private final UserSessionFactory userSessionFactory;
    private final OAuth2AuthenticationParameters oAuthParameters;

    public OAuth2ContextFactory(ThreadLocalUserSession threadLocalUserSession, UserIdentityAuthenticator userIdentityAuthenticator, Server server, OAuthCsrfVerifier csrfVerifier, JwtHttpHandler jwtHttpHandler, UserSessionFactory userSessionFactory, OAuth2AuthenticationParameters oAuthParameters) {
        this.threadLocalUserSession = threadLocalUserSession;
        this.userIdentityAuthenticator = userIdentityAuthenticator;
        this.server = server;
        this.csrfVerifier = csrfVerifier;
        this.jwtHttpHandler = jwtHttpHandler;
        this.userSessionFactory = userSessionFactory;
        this.oAuthParameters = oAuthParameters;
    }

    public OAuth2IdentityProvider.InitContext newContext(HttpServletRequest request, HttpServletResponse response, OAuth2IdentityProvider identityProvider) {
        return new OAuthContextImpl(request, response, identityProvider);
    }

    public OAuth2IdentityProvider.CallbackContext newCallback(HttpServletRequest request, HttpServletResponse response, OAuth2IdentityProvider identityProvider) {
        return new OAuthContextImpl(request, response, identityProvider);
    }

    private class OAuthContextImpl
    implements OAuth2IdentityProvider.InitContext,
    OAuth2IdentityProvider.CallbackContext {
        private final HttpServletRequest request;
        private final HttpServletResponse response;
        private final OAuth2IdentityProvider identityProvider;

        public OAuthContextImpl(HttpServletRequest request, HttpServletResponse response, OAuth2IdentityProvider identityProvider) {
            this.request = request;
            this.response = response;
            this.identityProvider = identityProvider;
        }

        public String getCallbackUrl() {
            return OAuth2ContextFactory.this.server.getPublicRootUrl() + "/oauth2/callback/" + this.identityProvider.getKey();
        }

        public String generateCsrfState() {
            return OAuth2ContextFactory.this.csrfVerifier.generateState(this.request, this.response);
        }

        public HttpServletRequest getRequest() {
            return this.request;
        }

        public HttpServletResponse getResponse() {
            return this.response;
        }

        public void redirectTo(String url) {
            try {
                this.response.sendRedirect(url);
            }
            catch (IOException e) {
                throw new IllegalStateException(String.format("Fail to redirect to %s", url), e);
            }
        }

        public void verifyCsrfState() {
            OAuth2ContextFactory.this.csrfVerifier.verifyState(this.request, this.response, this.identityProvider);
        }

        public void redirectToRequestedPage() {
            try {
                Optional<String> redirectTo = OAuth2ContextFactory.this.oAuthParameters.getReturnTo(this.request);
                OAuth2ContextFactory.this.oAuthParameters.delete(this.request, this.response);
                this.getResponse().sendRedirect(redirectTo.orElse(OAuth2ContextFactory.this.server.getContextPath() + "/"));
            }
            catch (IOException e) {
                throw new IllegalStateException("Fail to redirect to requested page", e);
            }
        }

        public void authenticate(UserIdentity userIdentity) {
            Boolean allowEmailShift = OAuth2ContextFactory.this.oAuthParameters.getAllowEmailShift(this.request).orElse(false);
            Boolean allowUpdateLogin = OAuth2ContextFactory.this.oAuthParameters.getAllowUpdateLogin(this.request).orElse(false);
            UserDto userDto = OAuth2ContextFactory.this.userIdentityAuthenticator.authenticate(UserIdentityAuthenticatorParameters.builder().setUserIdentity(userIdentity).setProvider((IdentityProvider)this.identityProvider).setSource(AuthenticationEvent.Source.oauth2(this.identityProvider)).setExistingEmailStrategy(allowEmailShift != false ? UserIdentityAuthenticatorParameters.ExistingEmailStrategy.ALLOW : UserIdentityAuthenticatorParameters.ExistingEmailStrategy.WARN).setUpdateLoginStrategy(allowUpdateLogin != false ? UserIdentityAuthenticatorParameters.UpdateLoginStrategy.ALLOW : UserIdentityAuthenticatorParameters.UpdateLoginStrategy.WARN).build());
            OAuth2ContextFactory.this.jwtHttpHandler.generateToken(userDto, this.request, this.response);
            OAuth2ContextFactory.this.threadLocalUserSession.set(OAuth2ContextFactory.this.userSessionFactory.create(userDto));
        }
    }
}

